/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.dar;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.ci.Versioned;
import com.xebialabs.deployit.ci.dar.SlaveRemoteDescriptorRegistry;
import com.xebialabs.deployit.packager.DarPackager;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.packager.writers.ManifestXmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import hudson.remoting.Callable;
import java.io.File;
import java.util.Collection;
import org.jenkinsci.remoting.RoleChecker;

public class RemotePackaging
implements Callable<String, RuntimeException> {
    private File targetDir;
    private DeploymentPackage deploymentPackage;
    private BooterConfig booterConfig;
    private Collection<Descriptor> descriptors;
    private String registryVersion;

    public RemotePackaging forDeploymentPackage(DeploymentPackage deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
        return this;
    }

    public RemotePackaging withTargetDir(File targetDir) {
        this.targetDir = targetDir;
        return this;
    }

    public RemotePackaging usingConfig(BooterConfig booterConfig) {
        this.booterConfig = booterConfig;
        return this;
    }

    public RemotePackaging usingDescriptors(Collection<Descriptor> descriptors) {
        this.descriptors = descriptors;
        return this;
    }

    public RemotePackaging withRegistryVersion(String registryVersion) {
        this.registryVersion = registryVersion;
        return this;
    }

    public String call() throws RuntimeException {
        Versioned versionedDescriptorRegistry;
        this.targetDir.mkdirs();
        ManifestXmlWriter mw = new ManifestXmlWriter();
        DarPackager pkger = new DarPackager((ManifestWriter)mw);
        DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.booterConfig);
        if (null == descriptorRegistry) {
            SlaveRemoteDescriptorRegistry.boot(this.descriptors, this.booterConfig, this.registryVersion);
        } else if (descriptorRegistry instanceof Versioned && !(versionedDescriptorRegistry = (Versioned)descriptorRegistry).getVersion().equals(this.registryVersion)) {
            SlaveRemoteDescriptorRegistry.boot(this.descriptors, this.booterConfig, this.registryVersion);
        }
        return pkger.buildPackage((Version)this.deploymentPackage, this.targetDir.getAbsolutePath(), true).getPath();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

