/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.ImportLocation;
import com.xebialabs.deployit.ci.ImportLocationDescriptor;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import org.kohsuke.stapler.DataBoundConstructor;

public class URLLocation
extends ImportLocation {
    public final String url;

    @DataBoundConstructor
    public URLLocation(String url) {
        this.url = url;
    }

    @Override
    public String getDarFileLocation(FilePath workspace, JenkinsDeploymentListener deploymentListener, EnvVars envVars) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.url), (Object)"URL is empty or null");
        return this.url;
    }

    public String toString() {
        return String.format("URLLocation[url: %s]", this.url);
    }

    @Extension
    public static final class DescriptorImpl
    extends ImportLocationDescriptor {
        @Override
        public String getDisplayName() {
            return "URL";
        }
    }
}

