/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.collect.Ordering;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployitNotifier;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.server.DeployitServer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.util.Secret;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RepositoryUtils {
    public static DeployitServer getDeployitServer(String credentialName, Credential overridingCredential, Job<?, ?> project) {
        Credential credential = RepositoryUtils.findCredential(credentialName);
        if (null != credential && null != overridingCredential) {
            credential = RepositoryUtils.retrieveOverridingCredential(credential, overridingCredential.getCredentialsId(), credential.getName(), overridingCredential.getUsername(), overridingCredential.getPassword(), overridingCredential.isUseGlobalCredential());
        }
        DeployitNotifier.DeployitDescriptor descriptor = RepositoryUtils.getDeployitDescriptor();
        return descriptor.getDeployitServer(credential, project);
    }

    public static DeployitServer getDeployitServerFromCredentialsId(String serverCredentialName, String credentialId, Job<?, ?> project) {
        Credential credential = RepositoryUtils.findCredential(serverCredentialName);
        if (null != credential && null != credentialId) {
            StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(credentialId, project.getParent());
            if (null == cred) {
                throw new IllegalArgumentException(Messages.DeployitNotifier_credentialIdNotFoundError(credentialId));
            }
            credential = RepositoryUtils.retrieveOverridingCredential(credential, credentialId, credential.getName(), cred.getUsername(), cred.getPassword(), true);
        }
        DeployitNotifier.DeployitDescriptor descriptor = RepositoryUtils.getDeployitDescriptor();
        return descriptor.getDeployitServer(credential, project);
    }

    public static Credential retrieveOverridingCredential(Credential credential, String credentialId, String name, String username, Secret password, boolean useGlobalCredential) {
        DeployitNotifier.DeployitDescriptor descriptor = RepositoryUtils.getDeployitDescriptor();
        String secondaryProxyUrl = credential.resolveProxyUrl(descriptor.getDeployitClientProxyUrl());
        String secondaryServerUrl = credential.resolveServerUrl(descriptor.getDeployitServerUrl());
        Credential.SecondaryServerInfo serverInfo = new Credential.SecondaryServerInfo(secondaryServerUrl, secondaryProxyUrl);
        credential = new Credential(name, username, password, credentialId, serverInfo, useGlobalCredential);
        return credential;
    }

    private static List<Credential> getGlobalCredentials() {
        return RepositoryUtils.getDeployitDescriptor().getCredentials();
    }

    public static Credential findCredential(String credentialName) {
        for (Credential credential : RepositoryUtils.getGlobalCredentials()) {
            if (!credentialName.equals(credential.getName())) continue;
            return credential;
        }
        throw new IllegalArgumentException(Messages.DeployitNotifier_credentialsNotFoundError(credentialName));
    }

    public static Credential retrieveOverridingCredentialFromProject(AbstractProject<?, ?> project) {
        Credential overridingCredential = null;
        DeployitNotifier notifier = RepositoryUtils.retrieveDeployitNotifierFromProject(project);
        if (null != notifier && null != (overridingCredential = notifier.getOverridingCredential()) && StringUtils.isEmpty((String)overridingCredential.getUsername()) && null != overridingCredential.getCredentialsId()) {
            DeployitNotifier.DeployitDescriptor descriptor = (DeployitNotifier.DeployitDescriptor)notifier.getDescriptor();
            String secondaryProxyUrl = overridingCredential.resolveProxyUrl(descriptor.getDeployitClientProxyUrl());
            String secondaryServerUrl = overridingCredential.resolveServerUrl(descriptor.getDeployitServerUrl());
            Credential.SecondaryServerInfo serverInfo = new Credential.SecondaryServerInfo(secondaryServerUrl, secondaryProxyUrl);
            StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(overridingCredential.getCredentialsId(), project.getParent());
            if (null != cred) {
                overridingCredential = new Credential(overridingCredential.getName(), cred.getUsername(), cred.getPassword(), overridingCredential.getCredentialsId(), serverInfo, false);
            }
        }
        return overridingCredential;
    }

    public static DeployitNotifier retrieveDeployitNotifierFromProject(AbstractProject<?, ?> project) {
        DeployitNotifier notifier = null;
        DeployitNotifier.DeployitDescriptor descriptor = RepositoryUtils.getDeployitDescriptor();
        if (null != project) {
            notifier = (DeployitNotifier)project.getPublishersList().get((Descriptor)descriptor);
        }
        return notifier;
    }

    public static List<String> environments(DeployitServer deployitServer) {
        List<String> envs = deployitServer.search("udm.Environment");
        return Ordering.natural().sortedCopy(envs);
    }

    public static Collection<String> getAllResourceTypes(DeployitServer deployitServer) {
        return deployitServer.getDescriptorRegistry().getDeployableResourceTypes();
    }

    public static Collection<String> getAllEmbeddedResourceTypes(DeployitServer deployitServer) {
        return deployitServer.getDescriptorRegistry().getEmbeddedDeployableTypes();
    }

    public static Collection<String> getAllArtifactTypes(DeployitServer deployitServer) {
        return deployitServer.getDescriptorRegistry().getDeployableArtifactTypes();
    }

    public static Collection<String> getPropertiesOf(DeployitServer deployitServer, String type) {
        return deployitServer.getDescriptorRegistry().getEditablePropertiesForDeployableType(type);
    }

    public static DeployitNotifier.DeployitDescriptor getDeployitDescriptor() {
        return (DeployitNotifier.DeployitDescriptor)Hudson.getInstance().getDescriptor(DeployitNotifier.class);
    }
}

