/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployitPerformer;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.JenkinsDeploymentOptions;
import com.xebialabs.deployit.ci.JenkinsImportOptions;
import com.xebialabs.deployit.ci.JenkinsPackageOptions;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.PackageProperty;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.server.DeployitServerFactory;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DeployitNotifier
extends Notifier {
    public final String credential;
    public final String application;
    public final String version;
    public final JenkinsPackageOptions packageOptions;
    public List<PackageProperty> packageProperties = Collections.emptyList();
    public final JenkinsImportOptions importOptions;
    public final JenkinsDeploymentOptions deploymentOptions;
    public final boolean verbose;
    public Credential overridingCredential;

    public DeployitNotifier(String credential, String application, String version, JenkinsPackageOptions packageOptions, JenkinsImportOptions importOptions, JenkinsDeploymentOptions deploymentOptions, boolean verbose, List<PackageProperty> packageProperties) {
        this(credential, application, version, packageOptions, importOptions, deploymentOptions, verbose, packageProperties, null);
    }

    @DataBoundConstructor
    public DeployitNotifier(String credential, String application, String version, JenkinsPackageOptions packageOptions, JenkinsImportOptions importOptions, JenkinsDeploymentOptions deploymentOptions, boolean verbose, List<PackageProperty> packageProperties, Credential overridingCredential) {
        this.credential = credential;
        this.application = application;
        this.version = version;
        this.packageOptions = packageOptions;
        this.importOptions = importOptions;
        this.deploymentOptions = deploymentOptions;
        this.verbose = verbose;
        this.packageProperties = packageProperties;
        this.overridingCredential = overridingCredential;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.credential != null) {
            String cred = this.credential;
            Credential credential = RepositoryUtils.findCredential(cred);
            if (null != credential && null != this.overridingCredential) {
                credential = RepositoryUtils.retrieveOverridingCredential(credential, this.overridingCredential.getCredentialsId(), credential.getName(), this.overridingCredential.getUsername(), this.overridingCredential.getPassword(), this.overridingCredential.isUseGlobalCredential());
            }
            DeployitDescriptor descriptor = RepositoryUtils.getDeployitDescriptor();
            DeployitServer deployitServer = descriptor.getDeployitServer(credential, (Job<?, ?>)build.getProject());
            DeployitPerformer.DeployitPerformerParameters performerParameters = new DeployitPerformer.DeployitPerformerParameters(this.packageOptions, this.packageProperties, this.importOptions, this.deploymentOptions, this.application, this.version, this.verbose);
            DeployitPerformer performer = new DeployitPerformer(build, launcher, listener, deployitServer, performerParameters);
            return performer.doPerform();
        }
        throw FormValidation.error((String)"Credentials are missing or have not been initialized");
    }

    public boolean showGolbalCredentials() {
        return this.overridingCredential.isUseGlobalCredential();
    }

    public Credential getOverridingCredential() {
        return this.overridingCredential;
    }

    @Extension
    public static final class DeployitDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String deployitServerUrl;
        private String deployitClientProxyUrl;
        private int connectionPoolSize = 10;
        private List<Credential> credentials = new ArrayList<Credential>();
        private static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
        private static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
        private static final Logger LOGGER = Logger.getLogger(Credential.class.getName());
        private final transient Map<String, SoftReference<DeployitServer>> credentialServerMap = new HashMap<String, SoftReference<DeployitServer>>();

        public DeployitDescriptor() {
            this.load();
        }

        private DeployitServer newDeployitServer(Credential credential, ItemGroup<?> itemGroup) {
            String serverUrl = credential.resolveServerUrl(this.deployitServerUrl);
            String proxyUrl = credential.resolveProxyUrl(this.deployitClientProxyUrl);
            int newConnectionPoolSize = this.connectionPoolSize > 0 ? this.connectionPoolSize : 10;
            int socketTimeout = 60000;
            String userName = credential.getUsername();
            String password = credential.getPassword().getPlainText();
            if (credential.isUseGlobalCredential()) {
                StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(credential.getCredentialsId(), itemGroup);
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Credentials for '%s' not found.", credential.getCredentialsId()));
                }
                userName = cred.getUsername();
                password = cred.getPassword().getPlainText();
            }
            return DeployitServerFactory.newInstance(serverUrl, proxyUrl, userName, password, newConnectionPoolSize, socketTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DeployitServer getDeployitServer(Credential credential, Job<?, ?> project) {
            DeployitServer deployitServer = null;
            if (null != credential) {
                SoftReference<DeployitServer> deployitServerRef = this.credentialServerMap.get(credential.getKey());
                if (null != deployitServerRef) {
                    deployitServer = deployitServerRef.get();
                }
                if (null == deployitServer) {
                    DeployitDescriptor deployitDescriptor = this;
                    synchronized (deployitDescriptor) {
                        deployitServer = this.newDeployitServer(credential, project.getParent());
                        this.credentialServerMap.put(credential.getKey(), new SoftReference<DeployitServer>(deployitServer));
                    }
                }
            }
            return deployitServer;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.deployitServerUrl = json.get("deployitServerUrl").toString();
            this.deployitClientProxyUrl = json.get("deployitClientProxyUrl").toString();
            String connectionPoolSizeString = json.get("connectionPoolSize").toString();
            if (!Strings.isNullOrEmpty((String)connectionPoolSizeString)) {
                this.connectionPoolSize = Integer.parseInt(connectionPoolSizeString);
            }
            this.credentials = req.bindJSONToList(Credential.class, json.get("credentials"));
            this.save();
            this.credentialServerMap.clear();
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DeployitNotifier_displayName();
        }

        public List<Credential> getCredentials() {
            return this.credentials;
        }

        public String getDeployitServerUrl() {
            return this.deployitServerUrl;
        }

        public String getDeployitClientProxyUrl() {
            return this.deployitClientProxyUrl;
        }

        public int getConnectionPoolSize() {
            return this.connectionPoolSize;
        }

        private FormValidation validateOptionalUrl(String url) {
            try {
                if (!Strings.isNullOrEmpty((String)url)) {
                    new URL(url);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"%s is not a valid URL.", (Object[])new Object[]{url});
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckDeployitServerUrl(@QueryParameter String deployitServerUrl) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            if (Strings.isNullOrEmpty((String)deployitServerUrl)) {
                return FormValidation.error((String)"Url required.");
            }
            return this.validateOptionalUrl(deployitServerUrl);
        }

        @RequirePOST
        public FormValidation doCheckDeployitClientProxyUrl(@QueryParameter String deployitClientProxyUrl) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            return this.validateOptionalUrl(deployitClientProxyUrl);
        }

        @RequirePOST
        public FormValidation doCheckConnectionPoolSize(@QueryParameter String connectionPoolSize) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            if (Strings.isNullOrEmpty((String)connectionPoolSize)) {
                return FormValidation.error((String)"Connection pool size is required.");
            }
            try {
                Integer value = Integer.parseInt(connectionPoolSize);
                if (value <= 0) {
                    return FormValidation.error((String)"Connection pool size may not be negative or zero.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"%s is not a valid integer.", (Object[])new Object[]{connectionPoolSize});
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialItems() {
            ListBoxModel m = new ListBoxModel();
            for (Credential c : this.credentials) {
                m.add(c.getName(), c.getName());
            }
            return m;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
            return new StandardUsernameListBoxModel().withAll((Iterable)creds);
        }

        @RequirePOST
        public FormValidation doCheckCredential(@QueryParameter String credential, @AncestorInPath AbstractProject project) {
            project.checkPermission(Item.CONFIGURE);
            DeployitNotifier deployitNotifier = RepositoryUtils.retrieveDeployitNotifierFromProject(project);
            String warningMsg = "Changing credentials may unintentionally change your deployables' types - check the definitions afterward.";
            if (null != deployitNotifier) {
                boolean hasCredential;
                boolean bl = hasCredential = null != deployitNotifier.credential;
                if (hasCredential && !deployitNotifier.credential.equals(credential)) {
                    return FormValidation.warning((String)("Please Save or Apply changes before you continue. " + warningMsg));
                }
            } else {
                return FormValidation.warning((String)("Please Save or Apply changes before you continue. " + warningMsg));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public AutoCompletionCandidates doAutoCompleteApplication(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            Credential overridingcredential;
            DeployitServer deployitServer;
            project.checkPermission(Item.CONFIGURE);
            String resolvedApplicationName = this.expandValue(value, (Job)project);
            AutoCompletionCandidates applicationCadidates = new AutoCompletionCandidates();
            String applicationName = DeployitServerFactory.getNameFromId(resolvedApplicationName);
            DeployitNotifier deployitNotifier = RepositoryUtils.retrieveDeployitNotifierFromProject(project);
            if (deployitNotifier != null && null != (deployitServer = RepositoryUtils.getDeployitServer(deployitNotifier.credential, overridingcredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project), project))) {
                List<String> applicationSuggestions = deployitServer.search("udm.Application", applicationName + "%");
                for (String applicationSuggestion : applicationSuggestions) {
                    applicationCadidates.add(applicationSuggestion);
                }
            }
            return applicationCadidates;
        }

        @RequirePOST
        public FormValidation doCheckApplication(@QueryParameter String credential, @QueryParameter String value, @AncestorInPath AbstractProject<?, ?> project) {
            project.checkPermission(Item.CONFIGURE);
            if ("Applications/".equals(value)) {
                return FormValidation.ok((String)"Fill in the application ID, eg Applications/PetClinic");
            }
            String resolvedName = this.expandValue(value, (Job)project);
            String applicationName = DeployitServerFactory.getNameFromId(resolvedName);
            Credential overridingcredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            DeployitServer deployitServer = RepositoryUtils.getDeployitServer(credential, overridingcredential, project);
            List<String> candidates = deployitServer.search("udm.Application", applicationName + "%");
            for (String candidate : candidates) {
                if (!candidate.endsWith("/" + applicationName)) continue;
                return FormValidation.ok();
            }
            if (!candidates.isEmpty()) {
                return FormValidation.warning((String)"Application does not exist, but will be created upon package import. Did you mean to type one of the following: %s?", (Object[])new Object[]{candidates});
            }
            return FormValidation.warning((String)"Application does not exist, but will be created upon package import.");
        }

        @RequirePOST
        public FormValidation doReloadTypes(@QueryParameter String credential, @AncestorInPath AbstractProject project) {
            project.checkPermission(Item.CONFIGURE);
            Credential overridingcredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            try {
                DeployitServer deployitServer = RepositoryUtils.getDeployitServer(credential, overridingcredential, project);
                if (null == deployitServer) {
                    return FormValidation.error((String)"Server not found for credential.");
                }
                deployitServer.reload();
                return FormValidation.ok((String)("Types reloaded from XL Deploy version " + deployitServer.getServerInfo().getVersion() + " at " + deployitServer.getBooterConfig().getUrl()));
            }
            catch (DeployitPluginException ex) {
                return FormValidation.error((String)String.format("Unable to reload types. Cause: %s.", ex.getMessage()));
            }
        }

        public String expandValue(String value, Job project) {
            String resolvedValue = null;
            try {
                resolvedValue = project.getEnvironment(null, TaskListener.NULL).expand(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            resolvedValue = resolvedValue == null ? value : resolvedValue;
            return resolvedValue;
        }
    }
}

