/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployableView;
import com.xebialabs.deployit.ci.DeployableViewDescriptor;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.dar.RemoteLookup;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.util.FileFinder;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.ci.util.ListBoxModels;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.overthere.local.LocalFile;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.remoting.Callable;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ArtifactView
extends DeployableView {
    public static final String FILE_URI_PROPERTY = "fileUri";
    public String location;

    @DataBoundConstructor
    public ArtifactView(String type, String name, String location, String tags, List<NameValuePair> properties) {
        super(type, name, tags, properties);
        this.location = location;
    }

    @Override
    public ConfigurationItem toConfigurationItem(DeployitDescriptorRegistry registry, FilePath workspace, EnvVars envVars, JenkinsDeploymentListener listener) {
        Artifact deployable = (Artifact)super.toConfigurationItem(registry, workspace, envVars, listener);
        if (this.isUriLocation(envVars)) {
            if (!deployable.hasProperty(FILE_URI_PROPERTY)) {
                throw new DeployitPluginException(String.format("Your version of XL Deploy does not support URI locations for artifacts: %s. Please specify a filesystem path instead.", this.getResolvedLocation(envVars)));
            }
            registry.setProperty((ConfigurationItem)deployable, FILE_URI_PROPERTY, this.getResolvedLocation(envVars));
        } else {
            String resolvedLocation = this.getResolvedLocation(envVars);
            try {
                File file = ArtifactView.findFileFromPattern(resolvedLocation, workspace, listener);
                deployable.setFile(LocalFile.valueOf((File)file));
            }
            catch (IOException e) {
                throw new DeployitPluginException(String.format("Unable to find artifact for deployable '%s' in '%s'", this.getName(), resolvedLocation), e);
            }
        }
        return deployable;
    }

    protected boolean isUriLocation(EnvVars envVars) {
        if (Strings.isNullOrEmpty((String)this.location)) {
            return false;
        }
        String expanded = this.getResolvedLocation(envVars);
        if (expanded.matches("[a-zA-Z]:(\\\\|/).*")) {
            return false;
        }
        try {
            return new URI(expanded).getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String getResolvedLocation(EnvVars envVars) {
        if (Strings.isNullOrEmpty((String)this.location)) {
            throw new DeployitPluginException(String.format("No location specified for '%s' of type '%s'", this.getName(), this.getType()));
        }
        return envVars.expand(this.location);
    }

    static File findFileFromPattern(String pattern, FilePath workspace, JenkinsDeploymentListener listener) throws IOException {
        String artifactPath = ArtifactView.findFilePathFromPattern(pattern, workspace, listener);
        return ArtifactView.fetchFile(artifactPath, workspace);
    }

    public static String findFilePathFromPattern(String pattern, FilePath workspace, JenkinsDeploymentListener listener) throws IOException {
        List fileNames;
        listener.info(String.format("Searching for '%s' in '%s'", pattern, workspace));
        FileFinder fileFinder = new FileFinder(pattern);
        try {
            fileNames = (List)workspace.act((FilePath.FileCallable)fileFinder);
        }
        catch (InterruptedException exception) {
            throw new IOException(String.format("Interrupted while searching for '%s' in '%s'", pattern, workspace), exception);
        }
        listener.info("Found file(s): " + fileNames);
        if (fileNames.size() > 1) {
            Localizable localizable = Messages._DeployitNotifier_TooManyFilesMatchingPattern();
            listener.error(localizable);
            throw new DeployitPluginException(String.valueOf(localizable));
        }
        if (fileNames.size() == 0) {
            Localizable localizable = Messages._DeployitNotifier_noArtifactsFound(pattern, workspace);
            listener.error(localizable);
            throw new DeployitPluginException(String.valueOf(localizable));
        }
        String artifactPath = (String)fileNames.get(0);
        return new FilePath(workspace, artifactPath).getRemote();
    }

    private static File fetchFile(String artifactPath, FilePath workspace) throws IOException {
        try {
            return (File)workspace.getChannel().call((Callable)new RemoteLookup(artifactPath, workspace.getRemote()));
        }
        catch (InterruptedException e) {
            throw new DeployitPluginException("Unable to fetch file", e);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DeployableViewDescriptor {
        public String getDisplayName() {
            return "Artifact";
        }

        public ListBoxModel doFillTypeItems(@QueryParameter(value="credential") @RelativePath(value="..") String credentialExistingArtifacts, @QueryParameter(value="credential") @RelativePath(value="../..") String credentialNewArtifacts, @AncestorInPath AbstractProject project) {
            String creds = credentialExistingArtifacts != null ? credentialExistingArtifacts : credentialNewArtifacts;
            Credential credential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            DeployitServer deployitServer = RepositoryUtils.getDeployitServer(creds, credential, project);
            return ListBoxModels.of(RepositoryUtils.getAllArtifactTypes(deployitServer));
        }
    }
}

