/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemCollectionConverter;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemMarshallingStrategy;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import hudson.PluginFirstClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import nl.javadude.scannit.Scannit;
import org.jboss.resteasy.util.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class XStreamReaderWriter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public static final XppDriver HIERARCHICAL_STREAM_DRIVER = new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_"));
    private static final XStream xStream = new XStreamWithoutReflectionConverter(HIERARCHICAL_STREAM_DRIVER);
    private static final AtomicReference<List<Converter>> CONVERTERS = new AtomicReference<ArrayList>(Lists.newArrayList());
    private static final Logger logger = LoggerFactory.getLogger(XStreamReaderWriter.class);

    public XStreamReaderWriter() {
        logger.debug("Created XStreamReaderWriter");
        this.init();
    }

    protected void init() {
        Collection<Converter> converters = this.allConverters();
        for (Converter converter : converters) {
            XStreamReaderWriter.registerConverter(converter);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader tccl = currentThread.getContextClassLoader();
        if (tccl instanceof PluginFirstClassLoader) {
            XStreamReaderWriter.getConfiguredXStream().setClassLoader(tccl);
        } else {
            XStreamReaderWriter.getConfiguredXStream().setClassLoader(this.getClass().getClassLoader());
        }
    }

    public static void registerConverter(Converter converter) {
        xStream.registerConverter(converter);
        XStreamProvider annotation = converter.getClass().getAnnotation(XStreamProvider.class);
        xStream.aliasType(annotation.tagName(), annotation.readable());
        CONVERTERS.get().add(converter);
    }

    public static void registerConfigurationItemAliases() {
        xStream.registerConverter((Converter)new ConfigurationItemCollectionConverter(xStream.getMapper()));
        xStream.setMarshallingStrategy((MarshallingStrategy)new ConfigurationItemMarshallingStrategy(1003));
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            xStream.aliasType(descriptor.getType().toString(), ConfigurationItem.class);
        }
    }

    private Collection<Converter> allConverters() {
        Set classes = Scannit.getInstance().getTypesAnnotatedWith(XStreamProvider.class);
        return Collections2.transform((Collection)classes, (Function)new Function<Class<?>, Converter>(){

            public Converter apply(Class<?> input) {
                Preconditions.checkArgument((boolean)Converter.class.isAssignableFrom(input));
                return XStreamReaderWriter.this.constructConverter(input);
            }
        });
    }

    protected Converter constructConverter(Class<?> clazz) {
        try {
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isForRegisteredConverter(type, genericType);
    }

    protected boolean isForRegisteredConverter(Class<?> type, Type genericType) {
        if (Collection.class.isAssignableFrom(type) && genericType != null) {
            logger.trace("Is a collection of: {}", (Object)genericType);
            Class baseType = Types.getCollectionBaseType(type, (Type)genericType);
            return baseType != null && this.canBeConverted(baseType);
        }
        if (Map.class.isAssignableFrom(type) && genericType != null) {
            logger.trace("Is a collection of: {}", (Object)genericType);
            Class keyClass = Types.getMapKeyType((Type)genericType);
            Class valueClass = Types.getMapValueType((Type)genericType);
            if (Collection.class.isAssignableFrom(valueClass)) {
                Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
                Class valueBaseClass = Types.getCollectionBaseType((Class)valueClass, (Type)valueType);
                return valueBaseClass != null && keyClass != null && this.canBeConverted(valueBaseClass) && this.canBeConverted(keyClass);
            }
            return keyClass != null && this.canBeConverted(keyClass) && valueClass != null && this.canBeConverted(valueClass);
        }
        return this.canBeConverted(type);
    }

    private boolean canBeConverted(Class type) {
        for (Converter converter : CONVERTERS.get()) {
            if (!converter.canConvert(type)) continue;
            return true;
        }
        boolean canConvert = Arrays.asList(String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class).contains(type);
        return canConvert;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("Reading {}", (Object)genericType);
        return this.read(entityStream, type, (String)httpHeaders.getFirst((Object)"BOOTER_CONFIG"));
    }

    private Object read(InputStream entityStream, Class<Object> type, String booterConfigKey) {
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put((Object)"BOOTER_CONFIG", (Object)booterConfigKey);
        return xStream.unmarshal(HIERARCHICAL_STREAM_DRIVER.createReader(entityStream), null, (DataHolder)dataHolder);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        logger.trace("Checking writeable: {} - {}", type, (Object)genericType);
        return this.isForRegisteredConverter(type, genericType);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("Writing {}", (Object)genericType);
        xStream.toXML(o, (Writer)new OutputStreamWriter(entityStream, "UTF-8"));
    }

    public static XStream getConfiguredXStream() {
        return xStream;
    }

    static class XStreamWithoutReflectionConverter
    extends XStream {
        public XStreamWithoutReflectionConverter(XppDriver hierarchicalStreamDriver) {
            super((HierarchicalStreamDriver)hierarchicalStreamDriver);
        }

        public void registerConverter(Converter converter, int priority) {
            if (!(converter instanceof ReflectionConverter)) {
                super.registerConverter(converter, priority);
            }
        }
    }
}

