/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.workflow;

import com.google.inject.Inject;
import com.xebialabs.deployit.ci.ArtifactView;
import com.xebialabs.deployit.ci.DeployitNotifier;
import com.xebialabs.deployit.ci.RemoteAwareLocation;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.util.ActionUtils;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class XLDeployPublishStep
extends AbstractStepImpl {
    public final String serverCredentials;
    public String overrideCredentialId;
    public final String darPath;

    @DataBoundConstructor
    public XLDeployPublishStep(String darPath, String serverCredentials) {
        this.darPath = darPath;
        this.serverCredentials = serverCredentials;
    }

    @DataBoundSetter
    public void setOverrideCredentialId(String overrideCredentialId) {
        this.overrideCredentialId = overrideCredentialId;
    }

    public static final class XLDeployPublishExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient XLDeployPublishStep step;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run<?, ?> run;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void run() throws Exception {
            JenkinsDeploymentListener deploymentListener = new JenkinsDeploymentListener(this.listener, false);
            String path = ArtifactView.findFilePathFromPattern(this.envVars.expand(this.step.darPath), this.ws, deploymentListener);
            RemoteAwareLocation location = this.getRemoteAwareLocation(path);
            try {
                Job job = this.run.getParent();
                DeployitServer deployitServer = RepositoryUtils.getDeployitServerFromCredentialsId(this.step.serverCredentials, this.step.overrideCredentialId, job);
                ConfigurationItem importedPackage = deployitServer.importPackage(location.getDarFileLocation(this.ws, deploymentListener, this.envVars));
                ActionUtils.addPublishAction(this.run, deployitServer.getBooterConfig(), importedPackage);
            }
            finally {
                location.cleanup();
            }
            return null;
        }

        private RemoteAwareLocation getRemoteAwareLocation(final String path) {
            return new RemoteAwareLocation(){

                @Override
                public String getDarFileLocation(FilePath workspace, JenkinsDeploymentListener deploymentListener, EnvVars envVars) {
                    return this.getRemoteAwareLocation(ws, path);
                }
            };
        }
    }

    @Extension
    public static final class XLDeployPublishStepDescriptor
    extends AbstractStepDescriptorImpl {
        private DeployitNotifier.DeployitDescriptor deployitDescriptor = new DeployitNotifier.DeployitDescriptor();

        public XLDeployPublishStepDescriptor() {
            super(XLDeployPublishExecution.class);
        }

        public String getFunctionName() {
            return "xldPublishPackage";
        }

        public String getDisplayName() {
            return "Publish a deployment package to XLDeploy";
        }

        public ListBoxModel doFillServerCredentialsItems() {
            return this.getDeployitDescriptor().doFillCredentialItems();
        }

        private DeployitNotifier.DeployitDescriptor getDeployitDescriptor() {
            this.deployitDescriptor.load();
            return this.deployitDescriptor;
        }
    }
}

