/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Strings2 {
    private static final char COMMA_SEPARATOR = ',';
    private static final String QUOTE_CHARACTER = "\"";
    private static final String AMP_MARKER = "::AMP::";
    private static final String EQUAL_MARKER = "::EQUAL::";
    private static final String AMP_ESCAPE_SEQ = "\\\\&";
    private static final String EQUAL_ESCAPE_SEQ = "\\\\=";

    public static List<String> commaSeparatedListToList(String commaSeparatedList) {
        return ImmutableList.copyOf((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)commaSeparatedList));
    }

    public static String stripEnclosingQuotes(String value) {
        return value.length() > 1 && value.startsWith(QUOTE_CHARACTER) && value.endsWith(QUOTE_CHARACTER) ? value.substring(1, value.length() - 1) : value;
    }

    public static Map convertToMap(String val) {
        val = Strings2.replaceEscapedCharactersWithMarkers(val);
        Map values = Splitter.on((char)'&').withKeyValueSeparator("=").split((CharSequence)val);
        return Collections.unmodifiableMap(Strings2.replaceMarkersWithEscapedCharacters(values));
    }

    public static Map<String, String> replaceMarkersWithEscapedCharacters(Map<String, String> values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            map.put(Strings2.replaceMarkers(entry.getKey()), Strings2.replaceMarkers(entry.getValue()));
        }
        return map;
    }

    private static String replaceEscapedCharactersWithMarkers(String val) {
        return val.replaceAll(AMP_ESCAPE_SEQ, AMP_MARKER).replaceAll(EQUAL_ESCAPE_SEQ, EQUAL_MARKER);
    }

    private static String replaceMarkers(String val) {
        return val.replaceAll(AMP_MARKER, "&").replaceAll(EQUAL_MARKER, "=");
    }
}

