/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.server;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.reflect.Reflection;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.server.DeployitServerImpl;
import com.xebialabs.deployit.ci.server.PluginFirstClassloaderInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class DeployitServerFactory {
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;

    public static boolean validConnection(String serverUrl, String proxyUrl, String username, String password, int connectionPoolSize, int socketTimeout) throws IllegalStateException {
        DeployitServerFactory.newInstance(serverUrl, proxyUrl, username, password, connectionPoolSize, socketTimeout).newCommunicator();
        return true;
    }

    public static DeployitServer newInstance(String serverUrl, String proxyUrl, String username, String password, int connectionPoolSize, int socketTimeout) {
        return DeployitServerFactory.newInstance(DeployitServerFactory.getBooterConfig(serverUrl, proxyUrl, username, password, connectionPoolSize, socketTimeout));
    }

    public static DeployitServer newInstance(BooterConfig booterConfig) {
        DeployitServerImpl server = new DeployitServerImpl(booterConfig);
        return (DeployitServer)Reflection.newProxy(DeployitServer.class, (InvocationHandler)new PluginFirstClassloaderInvocationHandler(server));
    }

    public static BooterConfig getBooterConfig(String serverUrl, String proxyUrl, String username, String password, int connectionPoolSize, int socketTimeout) {
        URL url;
        BooterConfig.Builder builder = BooterConfig.builder();
        try {
            url = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new DeployitPluginException("MalformedURLException", e);
        }
        builder.withHost(url.getHost()).withPort(url.getPort());
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            builder.withProtocol(BooterConfig.Protocol.HTTPS);
            builder.withPort(DeployitServerFactory.validateDefaultPort(url.getPort(), 443));
        } else {
            builder.withPort(DeployitServerFactory.validateDefaultPort(url.getPort(), 80));
        }
        if (url.getPath().length() > 0) {
            builder.withContext(url.getPath().substring(1));
        }
        if (!Strings.isNullOrEmpty((String)proxyUrl)) {
            URI proxyUri = URI.create(proxyUrl);
            builder.withProxyHost(proxyUri.getHost());
            builder.withProxyPort(proxyUri.getPort());
        }
        builder.withCredentials(username, password);
        builder.withConnectionPoolSize(connectionPoolSize);
        builder.withSocketTimeout(socketTimeout);
        return builder.build();
    }

    public static String getNameFromId(String id) {
        String[] nameParts = id.split("/");
        return nameParts[nameParts.length - 1];
    }

    public static String getParentId(String id) {
        Object[] nameParts = id.split("/");
        ArrayList list = Lists.newArrayList((Object[])nameParts);
        if (list.size() > 1) {
            list.remove(nameParts.length - 1);
        }
        return Joiner.on((String)"/").join((Iterable)list);
    }

    public static int validateDefaultPort(int urlPort, int defaultPort) {
        if (urlPort == -1) {
            return defaultPort;
        }
        return urlPort;
    }
}

