/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Monitor;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.booter.remote.RemoteDescriptor;
import com.xebialabs.deployit.booter.remote.RemoteDescriptorRegistry;
import com.xebialabs.deployit.booter.remote.RemotePropertyDescriptor;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.util.Strings2;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitDescriptorRegistryImpl
implements DeployitDescriptorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DeployitDescriptorRegistryImpl.class);
    private BooterConfig booterConfig;
    private Monitor LOCK = new Monitor();
    private Iterable<Descriptor> allDeployableDescriptors;
    private DeployitCommunicator communicator;
    private String version;
    private static final Function<Descriptor, String> DESCRIPTOR_TO_TYPE_NAME = new Function<Descriptor, String>(){

        public String apply(Descriptor input) {
            return input.getType().toString();
        }
    };
    private static final Function<PropertyDescriptor, String> PROPERTY_DESCRIPTOR_TO_NAME = new Function<PropertyDescriptor, String>(){

        public String apply(PropertyDescriptor input) {
            return input.getName();
        }
    };

    DeployitDescriptorRegistryImpl(BooterConfig booterConfig) {
        this.booterConfig = booterConfig;
        this.version = UUID.randomUUID().toString();
    }

    @Override
    public DeployitCommunicator getCommunicator() {
        block5: {
            this.LOCK.enter();
            try {
                if (null != this.communicator) break block5;
                try {
                    this.communicator = RemoteBooter.getCommunicator((BooterConfig)this.booterConfig);
                    LOG.debug("Reusing existing communicator for config: {}.", (Object)this.safeBooterConfigKey());
                }
                catch (IllegalStateException ex) {
                    LOG.debug("No communicator found for config: {}. Creating new DeployitCommunicator.", (Object)this.safeBooterConfigKey());
                    DescriptorRegistry.remove((DescriptorRegistryId)this.booterConfig);
                    this.communicator = RemoteBooter.boot((BooterConfig)this.booterConfig);
                }
                this.fixVersionDepl6949();
            }
            finally {
                this.LOCK.leave();
            }
        }
        return this.communicator;
    }

    private String safeBooterConfigKey() {
        String safePassword = this.booterConfig.getPassword().replaceAll(".", "*");
        return BooterConfig.builder().withProtocol(this.booterConfig.getProtocol()).withCredentials(this.booterConfig.getUsername(), safePassword).withHost(this.booterConfig.getHost()).withPort(this.booterConfig.getPort()).withContext(this.booterConfig.getContext()).withProxyHost(this.booterConfig.getProxyHost()).withProxyPort(this.booterConfig.getProxyPort()).build().getKey();
    }

    private RemoteDescriptorRegistry getDescriptorRegistry() {
        if (DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.booterConfig) == null) {
            this.getCommunicator();
        }
        return (RemoteDescriptorRegistry)DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.booterConfig);
    }

    @Override
    public Type typeForClass(Class<?> clazz) {
        return this.getDescriptorRegistry().lookupType(clazz);
    }

    @Override
    public Type typeForName(String name) {
        return this.getDescriptorRegistry().lookupType(name);
    }

    @Override
    public <T extends BaseConfigurationItem> T newInstance(Class<T> clazz, String id) {
        Type type = this.typeForClass(clazz);
        try {
            BaseConfigurationItem bci = (BaseConfigurationItem)clazz.newInstance();
            bci.setId(id);
            bci.setType(type);
            this.initSyntheticProperties(bci, type);
            return (T)bci;
        }
        catch (Throwable t) {
            String msg = String.format("Unable to create CI class '%s' with id: '%s'", clazz.toString(), id);
            throw new DeployitPluginException(msg, t);
        }
    }

    private <T extends BaseConfigurationItem> void initSyntheticProperties(T bci, Type type) {
        this.prefillPropertiesWithDefaultValues(bci, type);
    }

    private <T extends BaseConfigurationItem> void prefillPropertiesWithDefaultValues(T bci, Type type) {
        Collection propertyDescriptors = type.getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor pd : propertyDescriptors) {
            Object defaultValue = pd.getDefaultValue();
            if (defaultValue == null && PropertyKind.BOOLEAN == pd.getKind()) {
                defaultValue = false;
            }
            if (defaultValue == null) continue;
            bci.setProperty(pd.getName(), defaultValue);
        }
    }

    private void fixVersionDepl6949() {
        Type type = this.typeForClass(DeploymentPackage.class);
        if (type.isSubTypeOf(Type.valueOf(Version.class))) {
            this.addMissingPropertyDescriptor(type, "ignoreUndefinedPropertiesInManifest", PropertyKind.BOOLEAN, "true", true);
            this.addMissingPropertyDescriptor(type, "exportAllPasswords", PropertyKind.BOOLEAN, "false", true);
            this.addMissingPropertyDescriptor(type, "exportOnlyPasswordPlaceholders", PropertyKind.BOOLEAN, "true", true);
        }
    }

    private void addMissingPropertyDescriptor(Type parentType, String name, PropertyKind kind, String defaultValue, boolean hidden) {
        RemoteDescriptor descriptor = (RemoteDescriptor)parentType.getDescriptor();
        RemotePropertyDescriptor pd = (RemotePropertyDescriptor)descriptor.getPropertyDescriptor(name);
        Collection propertyDescriptors = descriptor.getPropertyDescriptors();
        if (null == pd) {
            pd = new RemotePropertyDescriptor();
            pd.setKind(kind);
            pd.setDefaultValue(defaultValue);
            pd.setFqn(parentType.toString() + "." + name);
            pd.setName(name);
            if (hidden) {
                pd.setHidden();
            }
        }
        propertyDescriptors.add(pd);
        descriptor.setPropertyDescriptors(propertyDescriptors);
    }

    @Override
    public ConfigurationItem newInstance(String typeName, String name) {
        Type type = this.getDescriptorRegistry().lookupType(typeName);
        ConfigurationItem ci = this.newInstance(type, name);
        return ci;
    }

    private ConfigurationItem newInstance(Type type, String id) {
        try {
            RemoteDescriptor remoteDescriptor = (RemoteDescriptor)this.getDescriptor(type);
            Object ci = remoteDescriptor.isAssignableTo(this.typeForClass(EmbeddedDeployable.class)) ? new BaseEmbeddedDeployable() : (remoteDescriptor.isAssignableTo(this.typeForClass(SourceArtifact.class)) ? (remoteDescriptor.isAssignableTo(this.typeForClass(FolderArtifact.class)) ? new BaseDeployableFolderArtifact() : new BaseDeployableFileArtifact()) : (remoteDescriptor.isAssignableTo(this.typeForClass(Deployable.class)) ? new BaseDeployable() : new BaseConfigurationItem()));
            ci.setId(id);
            ci.setType(type);
            for (PropertyDescriptor pd : remoteDescriptor.getPropertyDescriptors()) {
                String propertyName;
                if (!pd.isAsContainment() || null != ci.getProperty(propertyName = pd.getName())) continue;
                switch (pd.getKind()) {
                    case LIST_OF_CI: {
                        ci.setProperty(propertyName, (Object)Lists.newArrayList());
                        break;
                    }
                    case SET_OF_CI: {
                        ci.setProperty(propertyName, (Object)Sets.newHashSet());
                        break;
                    }
                }
            }
            this.initSyntheticProperties(ci, type);
            return ci;
        }
        catch (Throwable e) {
            String errorMsg = String.format("Unable to instantiate CI '%s' with id '%s'. %s", type, id, e.getMessage());
            throw new RuntimeException(errorMsg, e);
        }
    }

    @Override
    public Collection<Descriptor> getDescriptors() {
        return this.getDescriptorRegistry().getLoadedDescriptors();
    }

    @Override
    public Descriptor getDescriptor(String type) {
        return this.getDescriptorRegistry().getLoadedDescriptor(type);
    }

    private Descriptor getDescriptor(Type type) {
        return this.getDescriptorRegistry().getLoadedDescriptor(type);
    }

    @Override
    public void setProperty(ConfigurationItem ci, String propName, String value) {
        PropertyDescriptor pd = this.getDescriptor(ci.getType()).getPropertyDescriptor(propName);
        pd.set(ci, this.convertValue(value, pd));
    }

    private Object convertValue(String val, PropertyDescriptor pd) {
        if (val == null) {
            return null;
        }
        switch (pd.getKind()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(val);
            }
            case INTEGER: {
                if (val.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(val);
            }
            case CI: {
                return this.convertToCiRef(val, pd);
            }
            case SET_OF_STRING: {
                return Sets.newLinkedHashSet(this.splitValue(val));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(this.splitValue(val));
            }
            case SET_OF_CI: {
                return Sets.newLinkedHashSet(this.convertToCiRefs(val, pd));
            }
            case LIST_OF_CI: {
                return Lists.newArrayList(this.convertToCiRefs(val, pd));
            }
            case MAP_STRING_STRING: {
                return Strings2.convertToMap(val);
            }
        }
        return val;
    }

    private Iterable<ConfigurationItem> convertToCiRefs(String val, final PropertyDescriptor pd) {
        return FluentIterable.from(this.splitValue(val)).transform((Function)new Function<String, ConfigurationItem>(){

            @Nullable
            public ConfigurationItem apply(@Nullable String input) {
                return DeployitDescriptorRegistryImpl.this.convertToCiRef(input, pd);
            }
        });
    }

    private ConfigurationItem convertToCiRef(String name, PropertyDescriptor pd) {
        BaseConfigurationItem ci = new BaseConfigurationItem();
        ci.setId(name);
        ci.setType(pd.getReferencedType());
        return ci;
    }

    private Iterable<String> splitValue(String val) {
        return Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)val);
    }

    private Iterable<Descriptor> getAllDeployableDescriptors() {
        this.LOCK.enter();
        try {
            if (this.allDeployableDescriptors == null) {
                Predicate predicate = Predicates.or((Predicate)new DescriptorPredicate(this.typeForName("udm.Deployable")), (Predicate)new DescriptorPredicate(this.typeForName("udm.EmbeddedDeployable")));
                this.allDeployableDescriptors = FluentIterable.from(this.getDescriptors()).filter(predicate);
            }
        }
        finally {
            this.LOCK.leave();
        }
        return this.allDeployableDescriptors;
    }

    @Override
    public List<String> getDeployableArtifactTypes() {
        DescriptorPredicate predicate = new DescriptorPredicate(this.typeForName("udm.Artifact"));
        return this.toSortedDeployableTypeListing(predicate);
    }

    private List<String> toSortedDeployableTypeListing(Predicate<Descriptor> descriptorsWithType) {
        return FluentIterable.from(this.getAllDeployableDescriptors()).filter(descriptorsWithType).transform(DESCRIPTOR_TO_TYPE_NAME).toSortedList((Comparator)Ordering.natural());
    }

    @Override
    public List<String> getDeployableResourceTypes() {
        Predicate predicate = Predicates.not((Predicate)Predicates.or((Predicate)new DescriptorPredicate(this.typeForName("udm.Artifact")), (Predicate)new DescriptorPredicate(this.typeForName("udm.EmbeddedDeployable"))));
        return this.toSortedDeployableTypeListing((Predicate<Descriptor>)predicate);
    }

    @Override
    public List<String> getEmbeddedDeployableTypes() {
        DescriptorPredicate predicate = new DescriptorPredicate(this.typeForName("udm.EmbeddedDeployable"));
        return this.toSortedDeployableTypeListing(predicate);
    }

    @Override
    public List<String> getEditablePropertiesForDeployableType(String type) {
        final Type embeddedDeployableType = this.typeForName("udm.EmbeddedDeployable");
        Predicate<PropertyDescriptor> editablePropertyDescriptors = new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor pd) {
                return !pd.isHidden() && !pd.getName().equals("tags") && !pd.getName().equals("fileUri") && !DeployitDescriptorRegistryImpl.this.isEmbeddedProperty(pd, embeddedDeployableType);
            }
        };
        return this.getPropertiesForDeployableType(type, editablePropertyDescriptors);
    }

    @Override
    public List<String> getPropertiesForDeployableType(String type, Predicate<PropertyDescriptor> propertyPredicate) {
        Descriptor descriptor = this.getDescriptor(type);
        return FluentIterable.from((Iterable)descriptor.getPropertyDescriptors()).filter(propertyPredicate).transform(PROPERTY_DESCRIPTOR_TO_NAME).toSortedList((Comparator)Ordering.natural());
    }

    @Override
    public void addEmbedded(ConfigurationItem parent, ConfigurationItem embed) {
        Descriptor descriptor = this.getDescriptor(parent.getType().toString());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!this.isMatchingEmbeddedProperty(pd, embed.getType())) continue;
            Collection col = (Collection)pd.get(parent);
            if (col == null) {
                col = pd.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
                pd.set(parent, (Object)col);
            }
            col.add(embed);
            return;
        }
        throw new RuntimeException("Failed to find property that embeds " + embed + " into parent " + parent);
    }

    @Override
    public void reload() {
        this.LOCK.enter();
        try {
            LOG.warn("About to reload descriptor registry for config: {}.", (Object)this.safeBooterConfigKey());
            this.version = UUID.randomUUID().toString();
            this.getDescriptorRegistry().reboot(this.getCommunicator());
            this.allDeployableDescriptors = null;
        }
        finally {
            this.LOCK.leave();
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    private boolean isEmbeddedProperty(PropertyDescriptor pd, Type embeddedDeployableType) {
        return pd.isAsContainment() && (pd.getKind() == PropertyKind.LIST_OF_CI || pd.getKind() == PropertyKind.SET_OF_CI) && pd.getReferencedType().isSubTypeOf(embeddedDeployableType);
    }

    private boolean isMatchingEmbeddedProperty(PropertyDescriptor pd, Type matchType) {
        return pd.isAsContainment() && (pd.getKind() == PropertyKind.LIST_OF_CI || pd.getKind() == PropertyKind.SET_OF_CI) && pd.getReferencedType().equals((Object)matchType);
    }

    private static class DescriptorPredicate
    implements Predicate<Descriptor> {
        private Type type;

        DescriptorPredicate(Type type) {
            this.type = type;
        }

        public boolean apply(Descriptor input) {
            return input.isAssignableTo(this.type);
        }
    }
}

