/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.io.Files;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.ImportLocation;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;

public abstract class RemoteAwareLocation
extends ImportLocation {
    protected File localTempDir;
    protected FilePath localTempDar;

    protected String getRemoteAwareLocation(FilePath workspace, String location) {
        if (!workspace.isRemote()) {
            return location;
        }
        FilePath remoteDar = new FilePath(workspace.getChannel(), location);
        this.localTempDir = Files.createTempDir();
        this.localTempDar = new FilePath(new File(this.localTempDir, remoteDar.getName()));
        try {
            remoteDar.copyTo(this.localTempDar);
        }
        catch (Exception e) {
            String msg = String.format("Unable to copy remote dar '%s' to local temp directory '%s'.", remoteDar, this.localTempDar);
            throw new DeployitPluginException(msg, e);
        }
        return this.localTempDar.getRemote();
    }

    @Override
    public void cleanup() {
        try {
            if (this.localTempDar != null && this.localTempDar.exists()) {
                this.localTempDar.delete();
            }
            if (this.localTempDir != null && this.localTempDir.exists()) {
                this.localTempDir.delete();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

