/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.util.ListBoxModels;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.List;
import javax.annotation.Nullable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PackageProperty
extends NameValuePair {
    @DataBoundConstructor
    public PackageProperty(String propertyName, String propertyValue) {
        super(propertyName, propertyValue);
    }

    @Extension
    public static class PackagePropertyDescriptor
    extends Descriptor<NameValuePair> {
        public static String PACKAGE_TYPE = "udm.DeploymentPackage";
        public static final Predicate<PropertyDescriptor> ONLY_SIMPLE_EDITABLE_PROPERTIES = new Predicate<PropertyDescriptor>(){

            public boolean apply(@Nullable PropertyDescriptor pd) {
                return !pd.isHidden() && (pd.getKind().isSimple() || PropertyKind.LIST_OF_STRING == pd.getKind() || PropertyKind.SET_OF_STRING == pd.getKind() || PropertyKind.MAP_STRING_STRING == pd.getKind());
            }
        };

        public PackagePropertyDescriptor(Class<? extends NameValuePair> clazz) {
            super(clazz);
        }

        public PackagePropertyDescriptor() {
            super(PackageProperty.class);
        }

        public String getDisplayName() {
            return "PackageProperty";
        }

        public ListBoxModel doFillPropertyNameItems(@QueryParameter(value="credential") @RelativePath(value="../..") String credentialExistingProps, @QueryParameter(value="credential") @RelativePath(value="..") String credentialNewProps, @AncestorInPath AbstractProject<?, ?> project) {
            String creds = credentialExistingProps != null ? credentialExistingProps : credentialNewProps;
            String type = PACKAGE_TYPE;
            Credential overridingCredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            DeployitServer deployitServer = RepositoryUtils.getDeployitServer(creds, overridingCredential, project);
            DeployitDescriptorRegistry descriptorRegistry = deployitServer.getDescriptorRegistry();
            descriptorRegistry.typeForName(PACKAGE_TYPE);
            List<String> properties = descriptorRegistry.getPropertiesForDeployableType(type, ONLY_SIMPLE_EDITABLE_PROPERTIES);
            return ListBoxModels.of(properties);
        }
    }
}

