/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.DeployableView;
import com.xebialabs.deployit.ci.DeployableViewDescriptor;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.EmbeddedView;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.ci.util.Strings2;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JenkinsPackageOptions
implements Describable<JenkinsPackageOptions> {
    private final List<DeployableView> deployables;

    @DataBoundConstructor
    public JenkinsPackageOptions(List<DeployableView> deployables) {
        this.deployables = deployables;
    }

    public Descriptor<JenkinsPackageOptions> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public List<DeployableView> getDeployables() {
        return this.deployables;
    }

    public DeploymentPackage toDeploymentPackage(String applicationName, String version, List<? extends NameValuePair> packageProperties, DeployitDescriptorRegistry registry, FilePath workspace, EnvVars envVars, JenkinsDeploymentListener listener) {
        Application application = registry.newInstance(Application.class, applicationName);
        DeploymentPackage deploymentPackage = registry.newInstance(DeploymentPackage.class, version);
        deploymentPackage.setApplication(application);
        HashMap deployablesByFqn = Maps.newHashMap();
        if (null == this.deployables) {
            String msg = String.format("No deployables defined for deployment package. Application: '%s'.", applicationName);
            throw new DeployitPluginException(msg);
        }
        List<DeployableView> sortedDeployables = this.sortDeployables(this.deployables);
        for (DeployableView deployableView : sortedDeployables) {
            ConfigurationItem deployable = deployableView.toConfigurationItem(registry, workspace, envVars, listener);
            if (deployableView instanceof EmbeddedView) {
                this.linkEmbeddedToParent(deployablesByFqn, deployable, (EmbeddedView)deployableView, registry, listener);
            } else {
                deploymentPackage.addDeployable((Deployable)deployable);
            }
            deployablesByFqn.put(deployableView.getFullyQualifiedName(), deployable);
        }
        deploymentPackage.setProperty("deployables", (Object)deploymentPackage.getDeployables());
        if (packageProperties != null) {
            for (NameValuePair nameValuePair : packageProperties) {
                String value = Strings2.stripEnclosingQuotes(Strings.nullToEmpty((String)nameValuePair.propertyValue));
                value = envVars.expand(value);
                registry.setProperty((ConfigurationItem)deploymentPackage, nameValuePair.propertyName, value);
            }
        }
        return deploymentPackage;
    }

    private List<DeployableView> sortDeployables(List<DeployableView> deployables) {
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(deployables, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(EmbeddedView.class))));
        List embeddeds = Lists.newArrayList((Iterable)Iterables.filter(deployables, (Predicate)Predicates.instanceOf(EmbeddedView.class)));
        Collections.sort(embeddeds, new Comparator<EmbeddedView>(){

            @Override
            public int compare(EmbeddedView o1, EmbeddedView o2) {
                return o1.getParentName().split("/").length - o2.getParentName().split("/").length;
            }
        });
        result.addAll(embeddeds);
        return result;
    }

    private void linkEmbeddedToParent(Map<String, ConfigurationItem> deployablesByFqn, ConfigurationItem deployable, EmbeddedView embeddedView, DeployitDescriptorRegistry registry, JenkinsDeploymentListener listener) {
        ConfigurationItem parent = deployablesByFqn.get(embeddedView.getParentName());
        if (parent == null) {
            listener.error("Failed to find parent [" + embeddedView.getParentName() + "] that embeds [" + deployable + "]");
            throw new DeployitPluginException("Failed to find parent that embeds " + deployable);
        }
        registry.addEmbedded(parent, deployable);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JenkinsPackageOptions> {
        public String getDisplayName() {
            return "JenkinsPackageOptions";
        }

        public DescriptorExtensionList<DeployableView, DeployableViewDescriptor> deployables() {
            return Jenkins.getInstance().getDescriptorList(DeployableView.class);
        }

        public JenkinsPackageOptions newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JenkinsPackageOptions)super.newInstance(req, formData);
        }
    }
}

