/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployitNotifier;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.VersionKind;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.server.DeployitServerFactory;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JenkinsDeploymentOptions
implements Describable<JenkinsDeploymentOptions> {
    public String environment = "Environments/";
    public boolean generateDeployedOnUpgrade;
    public boolean skipMode;
    public boolean testMode;
    public boolean rollbackOnError;
    public final VersionKind versionKind;
    public String version;

    @DataBoundConstructor
    public JenkinsDeploymentOptions(String environment, VersionKind versionKind, boolean generateDeployedOnUpgrade, boolean skipMode, boolean testMode, boolean rollbackOnError) {
        this.generateDeployedOnUpgrade = generateDeployedOnUpgrade;
        this.skipMode = skipMode;
        this.testMode = testMode;
        this.rollbackOnError = rollbackOnError;
        this.environment = environment;
        this.versionKind = versionKind;
    }

    public Descriptor<JenkinsDeploymentOptions> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JenkinsDeploymentOptions> {
        public String getDisplayName() {
            return "DeploymentOptions";
        }

        @RequirePOST
        public ComboBoxModel doFillEnvironmentItems(@QueryParameter(value="credential") @RelativePath(value="..") String credential, @QueryParameter(value="credential") String credential2, @AncestorInPath AbstractProject project) {
            project.checkPermission(Item.CONFIGURE);
            String creds = !Strings.isNullOrEmpty((String)credential) ? credential : credential2;
            Credential overridingCredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            List<Object> environments = new ArrayList();
            if (!Strings.isNullOrEmpty((String)creds)) {
                DeployitServer deployitServer = RepositoryUtils.getDeployitServer(creds, overridingCredential, project);
                environments = RepositoryUtils.environments(deployitServer);
            }
            return new ComboBoxModel(environments);
        }

        @RequirePOST
        public FormValidation doCheckEnvironment(@QueryParameter(value="credential") @RelativePath(value="..") String credential, @QueryParameter(value="credential") String credential2, @QueryParameter String value, @AncestorInPath AbstractProject<?, ?> project) {
            DeployitNotifier.DeployitDescriptor deployitDescriptor;
            String resolvedValue;
            String environment;
            Credential overridingCredential;
            project.checkPermission(Item.CONFIGURE);
            if (Strings.isNullOrEmpty((String)value) || "Environments/".equals(value)) {
                return FormValidation.ok((String)"Fill in the target environment ID, eg Environments/MyEnv");
            }
            String creds = !Strings.isNullOrEmpty((String)credential) ? credential : credential2;
            DeployitServer deployitServer = RepositoryUtils.getDeployitServer(creds, overridingCredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project), project);
            List<String> candidates = deployitServer.search("udm.Environment", environment = DeployitServerFactory.getNameFromId(resolvedValue = (deployitDescriptor = this.getDeployitDescriptor()).expandValue(value, (Job)project)).trim());
            if (candidates.isEmpty()) {
                return FormValidation.warning((String)"Environment '%s' does not exist, please ensure it exists during deployment", (Object[])new Object[]{environment});
            }
            return FormValidation.ok();
        }

        protected DeployitNotifier.DeployitDescriptor getDeployitDescriptor() {
            return (DeployitNotifier.DeployitDescriptor)Jenkins.getInstance().getDescriptorOrDie(DeployitNotifier.class);
        }
    }
}

