/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.ArtifactView;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.ImportLocationDescriptor;
import com.xebialabs.deployit.ci.RemoteAwareLocation;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileSystemLocation
extends RemoteAwareLocation {
    public final String location;
    public final String workingDirectory;

    @DataBoundConstructor
    public FileSystemLocation(String location, String workingDirectory) {
        this.location = location;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public String getDarFileLocation(FilePath workspace, JenkinsDeploymentListener deploymentListener, EnvVars envVars) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.location), (Object)"location is empty or null");
        FilePath root = Strings.isNullOrEmpty((String)this.workingDirectory) ? workspace : new FilePath(workspace.getChannel(), this.workingDirectory);
        String resolvedLocation = "";
        try {
            resolvedLocation = envVars.expand(this.location);
            String path = ArtifactView.findFilePathFromPattern(resolvedLocation, root, deploymentListener);
            return this.getRemoteAwareLocation(workspace, path);
        }
        catch (IOException exception) {
            throw new DeployitPluginException(String.format("Unable to find DAR from %s in %s", resolvedLocation, root), exception);
        }
    }

    public String toString() {
        return String.format("FileSystemLocation[location: %s, workdir: %s]", this.location, this.workingDirectory);
    }

    @Extension
    public static final class DescriptorImpl
    extends ImportLocationDescriptor {
        @Override
        public String getDisplayName() {
            return "FileSystem";
        }
    }
}

