/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployableView;
import com.xebialabs.deployit.ci.DeployableViewDescriptor;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.RepositoryUtils;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.util.ListBoxModels;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.util.ListBoxModel;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class EmbeddedView
extends DeployableView {
    public String parentName;

    @DataBoundConstructor
    public EmbeddedView(String type, String name, String parentName, List<NameValuePair> properties) {
        super(type, name, "", properties);
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParentName() + "/" + this.name;
    }

    @Extension
    public static final class DescriptorImpl
    extends DeployableViewDescriptor {
        public String getDisplayName() {
            return "Embedded";
        }

        public ListBoxModel doFillTypeItems(@QueryParameter(value="credential") @RelativePath(value="..") String credentialExistingEmbeddeds, @QueryParameter(value="credential") @RelativePath(value="../..") String credentialNewEmbeddeds, @AncestorInPath AbstractProject<?, ?> project) {
            String creds = credentialExistingEmbeddeds != null ? credentialExistingEmbeddeds : credentialNewEmbeddeds;
            Credential credential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
            DeployitServer deployitServer = RepositoryUtils.getDeployitServer(creds, credential, project);
            return ListBoxModels.of(RepositoryUtils.getAllEmbeddedResourceTypes(deployitServer));
        }
    }
}

