/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.JenkinsDeploymentOptions;
import com.xebialabs.deployit.ci.JenkinsImportOptions;
import com.xebialabs.deployit.ci.JenkinsPackageOptions;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.PackageProperty;
import com.xebialabs.deployit.ci.VersionKind;
import com.xebialabs.deployit.ci.dar.RemotePackaging;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.server.DeployitServerFactory;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.List;

class DeployitPerformer {
    private AbstractBuild<?, ?> build;
    private JenkinsDeploymentListener deploymentListener;
    private BuildListener buildListener;
    private DeployitServer deployitServer;
    private DeployitPerformerParameters deploymentParameters;

    DeployitPerformer(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener, DeployitServer deployitServer, DeployitPerformerParameters deploymentParameters) {
        this.build = build;
        this.buildListener = buildListener;
        this.deployitServer = deployitServer;
        this.deploymentParameters = deploymentParameters;
        this.deploymentListener = new JenkinsDeploymentListener((TaskListener)buildListener, deploymentParameters.verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPerform() throws InterruptedException, IOException {
        EnvVars envVars = this.build.getEnvironment((TaskListener)this.buildListener);
        String resolvedApplication = envVars.expand(this.deploymentParameters.application);
        String applicationName = DeployitServerFactory.getNameFromId(resolvedApplication);
        List<String> qualifiedAppIds = this.deployitServer.search("udm.Application", applicationName);
        if (qualifiedAppIds.size() == 1) {
            resolvedApplication = qualifiedAppIds.get(0);
        }
        String resolvedVersion = envVars.expand(this.deploymentParameters.version);
        if (this.deploymentParameters.packageOptions != null) {
            this.deploymentListener.info(Messages.DeployitNotifier_package(resolvedApplication, resolvedVersion));
            this.verifyResolvedVersion(resolvedVersion);
            this.verifyResolvedApplication(resolvedApplication);
            FilePath workspace = this.build.getWorkspace();
            if (this.deploymentParameters.deploymentOptions != null && this.deploymentParameters.deploymentOptions.versionKind == VersionKind.Packaged) {
                this.deploymentParameters.deploymentOptions.setVersion(resolvedVersion);
            }
            DeployitDescriptorRegistry descriptorRegistry = this.deployitServer.getDescriptorRegistry();
            DeploymentPackage deploymentPackage = this.deploymentParameters.packageOptions.toDeploymentPackage(resolvedApplication, resolvedVersion, this.deploymentParameters.packageProperties, descriptorRegistry, workspace, envVars, this.deploymentListener);
            File targetDir = new File(workspace.absolutize().getRemote(), "deployitpackage");
            String packagedPath = (String)workspace.getChannel().call((Callable)new RemotePackaging().withTargetDir(targetDir).forDeploymentPackage(deploymentPackage).usingConfig(this.deployitServer.getBooterConfig()).usingDescriptors(Lists.newArrayList(descriptorRegistry.getDescriptors())).withRegistryVersion(this.deployitServer.getRegistryVersion()));
            if (this.deploymentParameters.importOptions != null && packagedPath != null) {
                this.deploymentParameters.importOptions.setGeneratedDarLocation(packagedPath);
            }
            this.deploymentListener.info(Messages.DeployitNotifier_packaged(resolvedApplication, packagedPath));
        }
        String importedVersion = "";
        if (this.deploymentParameters.importOptions != null) {
            String resolvedDarFileLocation = "";
            try {
                String darFileLocation = this.deploymentParameters.importOptions.getDarFileLocation(this.build.getWorkspace(), this.deploymentListener, envVars);
                resolvedDarFileLocation = envVars.expand(darFileLocation);
                this.deploymentListener.info(Messages.DeployitNotifier_import(resolvedDarFileLocation));
                ConfigurationItem uploadedPackage = this.deployitServer.importPackage(resolvedDarFileLocation);
                this.deploymentListener.info(Messages.DeployitNotifier_imported(resolvedDarFileLocation));
                importedVersion = uploadedPackage.getName();
            }
            catch (Exception e) {
                e.printStackTrace(this.buildListener.getLogger());
                this.deploymentListener.error(Messages.DeployitNotifier_import_error(resolvedDarFileLocation, e.getMessage()));
                boolean uploadedPackage = false;
                return uploadedPackage;
            }
            finally {
                this.deploymentParameters.importOptions.getMode().cleanup();
            }
        }
        if (this.deploymentParameters.deploymentOptions != null) {
            String resolvedEnvironment = envVars.expand(this.deploymentParameters.deploymentOptions.environment);
            this.deploymentListener.info(Messages.DeployitNotifier_startDeployment(resolvedApplication, resolvedEnvironment));
            String packageVersion = "";
            switch (this.deploymentParameters.deploymentOptions.versionKind) {
                case Other: {
                    packageVersion = resolvedVersion;
                    break;
                }
                case Packaged: {
                    packageVersion = !importedVersion.isEmpty() ? importedVersion : this.deploymentParameters.deploymentOptions.getVersion();
                }
            }
            this.verifyPackageVersion(packageVersion);
            this.verifyResolvedApplication(resolvedApplication);
            String versionId = Joiner.on((String)"/").join((Object)resolvedApplication, (Object)packageVersion, new Object[0]);
            this.deploymentListener.info(Messages.DeployitNotifier_deploy(versionId, resolvedEnvironment));
            try {
                this.deployitServer.deploy(versionId, resolvedEnvironment, this.deploymentParameters.deploymentOptions, this.deploymentListener);
            }
            catch (Exception e) {
                this.deploymentListener.error(Messages._DeployitNotifier_errorDeploy(e.getMessage()));
                return false;
            }
            this.deploymentListener.info(Messages.DeployitNotifier_endDeployment(resolvedApplication, resolvedEnvironment));
        }
        return true;
    }

    private void verifyResolvedApplication(String resolvedApplication) {
        if (Strings.isNullOrEmpty((String)resolvedApplication)) {
            String msg = String.format("Resolved application is '%s'. Please verify you have configured build correctly.", resolvedApplication);
            throw new DeployitPluginException(msg);
        }
    }

    private void verifyPackageVersion(String packageVersion) {
        if (Strings.isNullOrEmpty((String)packageVersion)) {
            String msg = String.format("Package version is '%s'. Please verify you have configured build correctly.", packageVersion);
            throw new DeployitPluginException(msg);
        }
    }

    private void verifyResolvedVersion(String packageVersion) {
        if (Strings.isNullOrEmpty((String)packageVersion)) {
            String msg = String.format("Package version is '%s'. Please verify you have configured build correctly.", packageVersion);
            throw new DeployitPluginException(msg);
        }
    }

    static class DeployitPerformerParameters {
        public JenkinsPackageOptions packageOptions;
        public List<PackageProperty> packageProperties;
        public JenkinsImportOptions importOptions;
        public JenkinsDeploymentOptions deploymentOptions;
        public String application;
        public String version;
        public boolean verbose;

        public DeployitPerformerParameters(JenkinsPackageOptions packageOptions, List<PackageProperty> packageProperties, JenkinsImportOptions importOptions, JenkinsDeploymentOptions deploymentOptions, String application, String version, boolean verbose) {
            this.packageOptions = packageOptions;
            this.packageProperties = packageProperties;
            this.importOptions = importOptions;
            this.deploymentOptions = deploymentOptions;
            this.application = application;
            this.version = version;
            this.verbose = verbose;
        }
    }
}

