/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.ci.util.Strings2;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class DeployableView
implements Describable<DeployableView> {
    public String type;
    public String name;
    public String tags;
    public List<NameValuePair> properties;

    protected DeployableView(String type, String name, String tags, List<NameValuePair> properties) {
        this.type = type;
        this.name = name;
        this.tags = tags;
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.name;
    }

    public ConfigurationItem toConfigurationItem(DeployitDescriptorRegistry registry, FilePath workspace, EnvVars envVars, JenkinsDeploymentListener listener) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getName()) ? 1 : 0) != 0, (Object)"Name is required.");
        ConfigurationItem deployable = registry.newInstance(this.type, envVars.expand(this.getName()));
        if (!Strings.isNullOrEmpty((String)this.tags)) {
            deployable.setProperty("tags", (Object)Sets.newHashSet(Strings2.commaSeparatedListToList(this.tags)));
        }
        if (this.properties != null) {
            for (NameValuePair pair : this.properties) {
                String value = Strings2.stripEnclosingQuotes(Strings.nullToEmpty((String)pair.propertyValue));
                value = envVars.expand(value);
                registry.setProperty(deployable, pair.propertyName, value);
            }
        }
        return deployable;
    }

    public Descriptor<DeployableView> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }
}

