/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.AbstractTestResultAdapter;
import com.splunk.splunkjenkins.model.TestCaseResult;
import com.splunk.splunkjenkins.model.TestStatus;
import hudson.Extension;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.util.ArrayList;
import java.util.List;

@Extension(optional=true)
public class JunitResultAdapter
extends AbstractTestResultAdapter<TestResultAction> {
    @Override
    public List<TestCaseResult> getTestResult(TestResultAction resultAction) {
        ArrayList<TestCaseResult> caseResults = new ArrayList<TestCaseResult>();
        TestResult result = resultAction.getResult();
        for (SuiteResult suite : result.getSuites()) {
            for (CaseResult testCase : suite.getCases()) {
                caseResults.add(this.convert(testCase, suite.getName()));
            }
        }
        return caseResults;
    }

    private TestCaseResult convert(CaseResult methodResult, String suiteName) {
        String buildUrl = "";
        if (methodResult.getRun() != null) {
            buildUrl = methodResult.getRun().getUrl();
        }
        TestCaseResult testCaseResult = new TestCaseResult();
        testCaseResult.setTestName(methodResult.getName());
        testCaseResult.setUniqueName(methodResult.getFullName());
        testCaseResult.setDuration(methodResult.getDuration());
        testCaseResult.setClassName(methodResult.getClassName());
        testCaseResult.setErrorDetails(methodResult.getErrorDetails());
        testCaseResult.setErrorStackTrace(methodResult.getErrorStackTrace());
        testCaseResult.setSkippedMessage(methodResult.getSkippedMessage());
        testCaseResult.setFailedSince(methodResult.getFailedSince());
        testCaseResult.setStderr(JunitResultAdapter.trimToLimit(methodResult.getStderr(), methodResult.getFullName(), buildUrl));
        testCaseResult.setStdout(JunitResultAdapter.trimToLimit(methodResult.getStdout(), methodResult.getFullName(), buildUrl));
        testCaseResult.setGroupName(suiteName);
        TestStatus status = TestStatus.SKIPPED;
        if (!methodResult.isSkipped()) {
            status = methodResult.isPassed() ? TestStatus.PASSED : TestStatus.FAILURE;
        }
        testCaseResult.setStatus(status);
        return testCaseResult;
    }
}

