/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.CoverageMetricsAdapter;
import hudson.Extension;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.Ratio;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import hudson.plugins.clover.results.ProjectCoverage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(optional=true)
public class CloverCoverageMetrics
extends CoverageMetricsAdapter<CloverBuildAction> {
    @Override
    public Map<CoverageMetricsAdapter.Metric, Integer> getMetrics(CloverBuildAction coverageAction) {
        ProjectCoverage projectCoverage = coverageAction.getResult();
        Map<CoverageMetricsAdapter.Metric, Integer> result = this.extract((AbstractCloverMetrics)projectCoverage);
        return result;
    }

    @Override
    public List<CoverageMetricsAdapter.CoverageDetail> getReport(CloverBuildAction coverageAction) {
        ProjectCoverage projectCoverage = coverageAction.getResult();
        ArrayList<CoverageMetricsAdapter.CoverageDetail> result = new ArrayList<CoverageMetricsAdapter.CoverageDetail>();
        CoverageMetricsAdapter.CoverageDetail summary = new CoverageMetricsAdapter.CoverageDetail("project", CoverageMetricsAdapter.CoverageLevel.PROJECT);
        result.add(summary);
        this.appendDetail(summary, (AbstractCloverMetrics)coverageAction);
        for (PackageCoverage pcover : projectCoverage.getChildren()) {
            CoverageMetricsAdapter.CoverageDetail packageDetail = new CoverageMetricsAdapter.CoverageDetail(pcover.getName(), CoverageMetricsAdapter.CoverageLevel.PACKAGE);
            result.add(packageDetail);
            this.appendDetail(packageDetail, (AbstractCloverMetrics)pcover);
            for (FileCoverage fcover : pcover.getChildren()) {
                CoverageMetricsAdapter.CoverageDetail fileDetail = new CoverageMetricsAdapter.CoverageDetail(pcover.getName(), CoverageMetricsAdapter.CoverageLevel.FILE);
                result.add(fileDetail);
                this.appendDetail(fileDetail, (AbstractCloverMetrics)fcover);
                for (ClassCoverage clazzCover : fcover.getChildren()) {
                    CoverageMetricsAdapter.CoverageDetail clazzDetail = new CoverageMetricsAdapter.CoverageDetail(clazzCover.getName(), CoverageMetricsAdapter.CoverageLevel.CLASS);
                    result.add(clazzDetail);
                    this.appendDetail(clazzDetail, (AbstractCloverMetrics)clazzCover);
                }
            }
        }
        return result;
    }

    private Map<CoverageMetricsAdapter.Metric, Integer> extract(AbstractCloverMetrics coverageObject) {
        HashMap<CoverageMetricsAdapter.Metric, Integer> result = new HashMap<CoverageMetricsAdapter.Metric, Integer>();
        this.putMetricIfExists(result, CoverageMetricsAdapter.Metric.METHOD, coverageObject.getMethodCoverage());
        this.putMetricIfExists(result, CoverageMetricsAdapter.Metric.STATEMENT, coverageObject.getStatementCoverage());
        this.putMetricIfExists(result, CoverageMetricsAdapter.Metric.CONDITIONAL, coverageObject.getConditionalCoverage());
        this.putMetricIfExists(result, CoverageMetricsAdapter.Metric.ELEMENT, coverageObject.getElementCoverage());
        return result;
    }

    private void putMetricIfExists(Map<CoverageMetricsAdapter.Metric, Integer> result, CoverageMetricsAdapter.Metric metric, Ratio ratio) {
        if (ratio.denominator > 0.0f) {
            result.put(metric, ratio.getPercentage());
        }
    }

    private void appendDetail(CoverageMetricsAdapter.CoverageDetail detail, AbstractCloverMetrics coverageObject) {
        this.appendDetail(detail, CoverageMetricsAdapter.Metric.METHOD, coverageObject.getMethodCoverage());
        this.appendDetail(detail, CoverageMetricsAdapter.Metric.STATEMENT, coverageObject.getStatementCoverage());
        this.appendDetail(detail, CoverageMetricsAdapter.Metric.CONDITIONAL, coverageObject.getConditionalCoverage());
        this.appendDetail(detail, CoverageMetricsAdapter.Metric.ELEMENT, coverageObject.getElementCoverage());
    }

    private void appendDetail(CoverageMetricsAdapter.CoverageDetail detail, CoverageMetricsAdapter.Metric metricName, Ratio ratio) {
        if (ratio.denominator == 0.0f) {
            return;
        }
        detail.add(String.valueOf((Object)metricName) + "_percentage", ratio.getPercentage());
        detail.add(String.valueOf((Object)metricName) + "_total", (int)ratio.denominator);
        detail.add(String.valueOf((Object)metricName) + "_covered", (int)ratio.numerator);
    }
}

