/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.PlainTextConsoleUtils;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.util.ByteArrayOutputStream2;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension(ordinal=2.147483646E9)
public class TeeConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final Logger LOG = Logger.getLogger(TeeConsoleLogFilter.class.getName());
    private static final long serialVersionUID = 1091734060617902662L;
    private static final String SUFFIX = "console";
    private String source;

    public TeeConsoleLogFilter(String source) {
        this.source = source;
    }

    public TeeConsoleLogFilter(Run run) {
        if (run != null) {
            this.source = run.getUrl() + SUFFIX;
        }
    }

    public TeeConsoleLogFilter() {
        this.source = "Jobconsole";
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream output) throws IOException, InterruptedException {
        return this.decorateLogger((Run)build, output);
    }

    public OutputStream decorateLogger(Run build, OutputStream output) throws IOException, InterruptedException {
        Object logSource = this.source;
        boolean useLineNumber = true;
        if (build != null) {
            logSource = build.getUrl() + SUFFIX;
        } else {
            useLineNumber = false;
        }
        return this.teeOutput(output, (String)logSource, useLineNumber, SplunkJenkinsInstallation.get().getMaxEventsBatchSize());
    }

    public OutputStream decorateLogger(Computer computer, OutputStream logger) throws IOException, InterruptedException {
        Object logSource = this.source;
        if (computer != null) {
            logSource = computer.getUrl() + SUFFIX;
        }
        long cacheSize = Math.min(SplunkJenkinsInstallation.get().getMaxEventsBatchSize(), (long)Constants.SLAVE_LOG_BUFFER_SIZE);
        return this.teeOutput(logger, (String)logSource, false, cacheSize);
    }

    private OutputStream teeOutput(OutputStream output, String source, boolean useLineNumber, long cacheSize) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.CONSOLE_LOG)) {
            return output;
        }
        if (SplunkJenkinsInstallation.get().isJobIgnored(source)) {
            return output;
        }
        TeeOutputStream teeOutput = new TeeOutputStream(output, source);
        teeOutput.setRequireLineNumber(useLineNumber);
        teeOutput.setCacheSize(cacheSize);
        return teeOutput;
    }

    public static class TeeOutputStream
    extends FilterOutputStream {
        private static final int LF = 10;
        boolean requireLineNumber = true;
        String sourceName;
        long lineCounter = 0L;
        private static final int RECEIVE_BUFFER_SIZE = 512;
        private ByteArrayOutputStream2 branch = new ByteArrayOutputStream2(512);
        private ByteArrayOutputStream2 logText = new ByteArrayOutputStream2(Constants.MIN_BUFFER_SIZE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        private long cacheSize = Constants.MIN_BUFFER_SIZE;

        public void setCacheSize(long cacheSize) {
            this.cacheSize = cacheSize;
        }

        public void setRequireLineNumber(boolean requireLineNumber) {
            this.requireLineNumber = requireLineNumber;
        }

        public TeeOutputStream(OutputStream out, String sourceName) {
            super(out);
            this.sourceName = sourceName;
            LOG.log(Level.FINE, "created splunk output tee for " + sourceName);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.flushLog();
            this.logText.close();
            this.branch.close();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.flushLog();
            this.branch.reset();
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.branch.write(b);
            if (b == 10 || this.branch.size() > Constants.CONSOLE_TEXT_SINGLE_LINE_MAX_LENGTH) {
                this.eol();
            }
        }

        private void eol() throws IOException {
            if (this.branch.size() == 0) {
                return;
            }
            ++this.lineCounter;
            String prefix = this.sdf.format(new Date()) + "  ";
            this.logText.write(prefix.getBytes(StandardCharsets.UTF_8));
            if (this.requireLineNumber) {
                this.logText.write(("line:" + this.lineCounter + "  ").getBytes(StandardCharsets.UTF_8));
            }
            PlainTextConsoleUtils.decodeConsole(this.branch.getBuffer(), this.branch.size(), (ByteArrayOutputStream)this.logText);
            if ((long)this.logText.size() >= this.cacheSize) {
                this.flushLog();
            }
            this.branch.reset();
        }

        private void flushLog() {
            if (this.logText.size() == 0) {
                return;
            }
            try {
                String logs = this.logText.toString("UTF-8");
                SplunkLogService.getInstance().send(logs, EventType.CONSOLE_LOG, this.sourceName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.logText.reset();
        }
    }
}

