/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.google.common.base.Strings;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.CustomSSLConnectionSocketFactory;
import com.splunk.splunkjenkins.utils.LogConsumer;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.MultipleHostResolver;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import shaded.splk.org.apache.http.HttpResponse;
import shaded.splk.org.apache.http.client.HttpClient;
import shaded.splk.org.apache.http.client.config.RequestConfig;
import shaded.splk.org.apache.http.config.Registry;
import shaded.splk.org.apache.http.config.RegistryBuilder;
import shaded.splk.org.apache.http.config.SocketConfig;
import shaded.splk.org.apache.http.conn.ConnectionKeepAliveStrategy;
import shaded.splk.org.apache.http.conn.DnsResolver;
import shaded.splk.org.apache.http.conn.HttpClientConnectionManager;
import shaded.splk.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import shaded.splk.org.apache.http.conn.ssl.NoopHostnameVerifier;
import shaded.splk.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.splk.org.apache.http.conn.ssl.TrustStrategy;
import shaded.splk.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import shaded.splk.org.apache.http.impl.client.HttpClients;
import shaded.splk.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import shaded.splk.org.apache.http.protocol.HttpContext;
import shaded.splk.org.apache.http.ssl.SSLContexts;

public class SplunkLogService {
    public static final Logger LOG = Logger.getLogger(SplunkLogService.class.getName());
    private static final boolean VERIFY_SSL = Boolean.getBoolean("splunkins.verifySSL");
    private static final int SOCKET_TIMEOUT = 3;
    private static final int QUEUE_SIZE = Integer.getInteger(SplunkLogService.class.getName() + ".queueSize", 131072);
    private static final long KEEP_ALIVE_TIME_MINUTES = 2L;
    int MAX_WORKER_COUNT = Integer.getInteger(SplunkLogService.class.getName() + ".workerCount", 2);
    BlockingQueue<EventRecord> logQueue;
    List<LogConsumer> workers;
    HttpClient client;
    HttpClientConnectionManager connMgr;
    private AtomicLong incomingCounter = new AtomicLong();
    private AtomicLong outgoingCounter = new AtomicLong();
    private Lock maintenanceLock = new ReentrantLock();

    private SplunkLogService() {
        this.logQueue = new LinkedBlockingQueue<EventRecord>(QUEUE_SIZE);
        this.workers = new ArrayList<LogConsumer>();
    }

    private void initHttpClient() {
        this.connMgr = this.buildConnectionManager();
        DefaultConnectionKeepAliveStrategy myStrategy = new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                long keepAliveTime = super.getKeepAliveDuration(httpResponse, httpContext);
                if (keepAliveTime == -1L) {
                    keepAliveTime = TimeUnit.MINUTES.toMillis(2L);
                }
                return keepAliveTime;
            }
        };
        this.client = HttpClients.custom().setConnectionManager(this.connMgr).setKeepAliveStrategy((ConnectionKeepAliveStrategy)myStrategy).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).useSystemProperties().build();
    }

    public static SplunkLogService getInstance() {
        return InstanceHolder.service;
    }

    private HttpClientConnectionManager buildConnectionManager() {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        if (!VERIFY_SSL) {
            SSLContext sslContext = null;
            try {
                TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
                sslContext = SSLContexts.custom().setProtocol("TLSv1.2").loadTrustMaterial(null, (shaded.splk.org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            }
            catch (Exception e) {
                sslContext = SSLContexts.createDefault();
            }
            sslConnectionSocketFactory = new CustomSSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        } else {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry, null, null, (DnsResolver)new MultipleHostResolver(), -1L, TimeUnit.MINUTES);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        SocketConfig defaultSocketConfig = SocketConfig.custom().setSoTimeout((int)TimeUnit.MINUTES.toMillis(3L)).build();
        cm.setDefaultSocketConfig(defaultSocketConfig);
        return cm;
    }

    public boolean send(Object message) {
        if (message != null && message instanceof EventRecord) {
            return this.enqueue((EventRecord)message);
        }
        return this.send(message, null, null);
    }

    public boolean send(Object message, String sourceName) {
        return this.send(message, null, sourceName);
    }

    public boolean send(Object message, EventType eventType) {
        return this.send(message, eventType, null);
    }

    public boolean sendBatch(Collection<? extends Object> messages, EventType eventType) {
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long batchSize = SplunkJenkinsInstallation.get().getMaxEventsBatchSize();
        boolean isQueued = false;
        for (Object object : messages) {
            EventRecord record = !(object instanceof EventRecord) ? new EventRecord(object, eventType) : (EventRecord)object;
            Object content = record.getMessage();
            if (content == null || "".equals(content) || "\n".equals(content)) continue;
            stringBuffer.append(LogEventHelper.toJson(record));
            stringBuffer.append("\n");
            if ((long)stringBuffer.length() <= batchSize) continue;
            isQueued = this.enqueue(new EventRecord(stringBuffer.toString(), EventType.BATCH_JSON));
            stringBuffer.setLength(0);
            if (isQueued) continue;
            return isQueued;
        }
        if (stringBuffer.length() > 0) {
            isQueued = this.enqueue(new EventRecord(stringBuffer.toString(), EventType.BATCH_JSON));
        }
        return isQueued;
    }

    public boolean send(Object message, EventType eventType, String sourceName) {
        if (this.connMgr == null) {
            return false;
        }
        if (message == null) {
            LOG.warning("null message discarded");
            return false;
        }
        if (message instanceof String && ((String)message).length() == 0) {
            LOG.warning("empty message discarded");
            return false;
        }
        EventRecord record = new EventRecord(message, eventType);
        if (!Strings.isNullOrEmpty((String)sourceName)) {
            record.setSource(sourceName);
        }
        return this.enqueue(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(EventRecord record) {
        long incomingCount;
        if (SplunkJenkinsInstallation.get().isEventDisabled(record.getEventType())) {
            LOG.log(Level.FINE, "config invalid or eventType {0} is disabled, can not send {1}", new String[]{record.getEventType().toString(), record.getShortDescription()});
            return false;
        }
        boolean added = this.logQueue.offer(record);
        if (!added) {
            added = this.maintainQueue(record);
        }
        if (this.workers.size() < this.MAX_WORKER_COUNT) {
            List<LogConsumer> list = this.workers;
            synchronized (list) {
                int worksToCreate = this.MAX_WORKER_COUNT - this.workers.size();
                for (int i = 0; i < worksToCreate; ++i) {
                    LogConsumer workerThread = new LogConsumer(this.client, this.logQueue, this.outgoingCounter);
                    this.workers.add(workerThread);
                    String workerThreadName = "splunkins-worker-" + this.workers.size();
                    workerThread.setName(workerThreadName);
                    workerThread.start();
                }
            }
        }
        if ((incomingCount = this.incomingCounter.incrementAndGet()) % 4000L == 0L && this.getQueueSize() > 4000L) {
            LOG.info(this.getStats());
            SplunkLogService splunkLogService = InstanceHolder.service;
            synchronized (splunkLogService) {
                this.connMgr.closeIdleConnections(2L, TimeUnit.MINUTES);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maintainQueue(EventRecord record) {
        boolean added = false;
        this.maintenanceLock.lock();
        try {
            this.removeDeadWorker();
            if (this.logQueue.remainingCapacity() > 2000) {
                added = this.logQueue.offer(record);
            }
            if (!added) {
                ArrayList stuckRecords = new ArrayList(this.logQueue.size());
                this.logQueue.drainTo(stuckRecords);
                LOG.log(Level.SEVERE, "jenkins is too busy or has too few workers, clearing up queue");
                int count = 0;
                for (EventRecord queuedRecord : stuckRecords) {
                    if (queuedRecord.getEventType().ordinal() > EventType.JENKINS_CONFIG.ordinal()) {
                        ++count;
                        continue;
                    }
                    if (this.logQueue.offer(queuedRecord)) continue;
                    break;
                }
                stuckRecords.clear();
                added = this.logQueue.offer(record);
                LOG.log(Level.INFO, "discarded: {0}, remaining: {1}", new Object[]{count, this.logQueue.size()});
            }
        }
        finally {
            this.maintenanceLock.unlock();
        }
        return added;
    }

    private void removeDeadWorker() {
        Iterator<LogConsumer> workerIterator = this.workers.iterator();
        while (workerIterator.hasNext()) {
            if (workerIterator.next().isAlive()) continue;
            workerIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorker() {
        List<LogConsumer> list = this.workers;
        synchronized (list) {
            for (LogConsumer consumer : this.workers) {
                consumer.stopTask();
            }
            this.workers.clear();
        }
        long queueLength = this.getQueueSize();
        if (queueLength > 0L) {
            this.logQueue.clear();
            LOG.severe("remaining " + queueLength + " record(s) not sent");
        }
    }

    public void releaseConnection() {
        this.connMgr.closeIdleConnections(0L, TimeUnit.SECONDS);
    }

    public long getSentCount() {
        return this.outgoingCounter.get();
    }

    public long getQueueSize() {
        return this.logQueue.size();
    }

    public HttpClient getClient() {
        return this.client;
    }

    public String getStats() {
        StringBuilder sbr = new StringBuilder();
        sbr.append("remaining:").append(this.getQueueSize()).append(" ").append("sent:").append(this.getSentCount());
        return sbr.toString();
    }

    private static class InstanceHolder {
        static SplunkLogService service = new SplunkLogService();

        private InstanceHolder() {
        }

        static {
            try {
                service.initHttpClient();
            }
            catch (NoSuchFieldError e) {
                LOG.log(Level.SEVERE, "init httpclient failed, version conflicts", e);
            }
        }
    }

    static class TrustAllStrategy
    implements TrustStrategy {
        TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] certificate, String type) {
            return true;
        }
    }
}

