/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EventRecord {
    private static final String[] METADATA_KEYS = new String[]{"index", "source", "sourcetype"};
    private static final String MESSAGE_CLEARED = "error: message was cleared for memory demand by garbage collector";
    private long time;
    private int retryCount = 0;
    private Object message;
    private EventType eventType;
    private String source;

    public EventRecord(Object message, EventType eventType) {
        this.eventType = eventType == null ? EventType.LOG : eventType;
        this.time = System.currentTimeMillis();
        if (message == null) {
            throw new RuntimeException("null message not allowed");
        }
        this.message = message;
    }

    public void increase() {
        ++this.retryCount;
    }

    public boolean isDiscarded() {
        try {
            return (long)this.retryCount > SplunkJenkinsInstallation.get().getMaxRetries();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @NonNull
    public Object getMessage() {
        if (this.message instanceof SoftReference) {
            String text = (String)((SoftReference)this.message).get();
            if (text == null) {
                text = MESSAGE_CLEARED;
            }
            return text;
        }
        return this.message;
    }

    public String getMessageString() {
        return this.getMessage().toString();
    }

    private boolean isString() {
        return this.message instanceof String;
    }

    public String getShortDescription() {
        if (this.isString()) {
            return "{length:" + ((String)this.message).length() + " " + StringUtils.substring((String)((String)this.message), (int)0, (int)160) + " ...}";
        }
        if (this.message.getClass().getName().contains("LazyMap")) {
            return "{source:" + this.source + ", message class is LazyMap}";
        }
        return "{raw data" + StringUtils.abbreviate((String)String.valueOf(this.message), (int)160) + "}";
    }

    public String getTimestamp() {
        return String.format(Locale.US, "%.3f", (double)this.time / 1000.0);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @NonNull
    public EventType getEventType() {
        return this.eventType;
    }

    private Map<String, String> getMetaData(SplunkJenkinsInstallation config) {
        LogEventHelper.UrlQueryBuilder metaDataBuilder = new LogEventHelper.UrlQueryBuilder();
        metaDataBuilder.putIfAbsent("source", this.source);
        for (String metaDataKey : METADATA_KEYS) {
            metaDataBuilder.putIfAbsent(metaDataKey, config.getMetaData(this.eventType.getKey(metaDataKey)));
        }
        if (this.isString()) {
            metaDataBuilder.putIfAbsent("sourcetype", config.getMetaData("sourcetype_text"));
        }
        if (this.eventType == EventType.LOG) {
            metaDataBuilder.putIfAbsent("index", config.getMetaData(EventType.CONSOLE_LOG.getKey("index")));
        }
        for (String metaDataKey : METADATA_KEYS) {
            metaDataBuilder.putIfAbsent(metaDataKey, config.getMetaData(metaDataKey));
        }
        metaDataBuilder.putIfAbsent("host", config.getMetadataHost());
        return metaDataBuilder.getQueryMap();
    }

    public String getRawEndpoint(SplunkJenkinsInstallation config) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.putAll(this.getMetaData(config));
        return config.getRawUrl() + "?" + LogEventHelper.UrlQueryBuilder.toString(queryMap);
    }

    public Map<String, Object> toMap(SplunkJenkinsInstallation config) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("time", this.getTimestamp());
        values.put("event", this.getMessage());
        Map<String, String> metaDataConfig = this.getMetaData(config);
        values.putAll(metaDataConfig);
        return values;
    }

    public boolean isFailed() {
        return this.retryCount > 0;
    }
}

