/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.AbstractTestResultAdapter;
import com.splunk.splunkjenkins.model.TestCaseResult;
import com.splunk.splunkjenkins.model.TestStatus;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import hudson.Extension;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jenkinsci.plugins.cucumber.jsontestsupport.BeforeAfterResult;
import org.jenkinsci.plugins.cucumber.jsontestsupport.CucumberTestResultAction;
import org.jenkinsci.plugins.cucumber.jsontestsupport.FeatureResult;
import org.jenkinsci.plugins.cucumber.jsontestsupport.ScenarioResult;
import org.jenkinsci.plugins.cucumber.jsontestsupport.StepResult;

@Extension(optional=true)
public class CucumberTestResultAdapter
extends AbstractTestResultAdapter<CucumberTestResultAction> {
    @Override
    public List<TestCaseResult> getTestResult(CucumberTestResultAction resultAction) {
        ArrayList<TestCaseResult> caseResults = new ArrayList<TestCaseResult>();
        Collection featureResults = resultAction.getResult().getChildren();
        String prefix = resultAction.getResult().getName() + "/";
        for (FeatureResult featureResult : featureResults) {
            for (ScenarioResult scenarioResult : featureResult.getChildren()) {
                TestCaseResult testCaseResult;
                String className = scenarioResult.getId();
                if (className.startsWith(prefix)) {
                    className = className.substring(prefix.length());
                }
                for (BeforeAfterResult beforeAfterResult : scenarioResult.getBeforeResults()) {
                    testCaseResult = this.convert((TestResult)beforeAfterResult, className);
                    caseResults.add(testCaseResult);
                }
                for (StepResult stepResult : scenarioResult.getStepResults()) {
                    testCaseResult = this.convert((TestResult)stepResult, className);
                    testCaseResult.setTestName(this.getStepName(stepResult));
                    caseResults.add(testCaseResult);
                }
                for (BeforeAfterResult afterResult : scenarioResult.getAfterResults()) {
                    testCaseResult = this.convert((TestResult)afterResult, className);
                    caseResults.add(testCaseResult);
                }
            }
        }
        return caseResults;
    }

    private TestCaseResult convert(TestResult testResult, String className) {
        TestObject parent;
        TestCaseResult testCaseResult = new TestCaseResult();
        testCaseResult.setTestName(testResult.getName());
        testCaseResult.setClassName(className);
        testCaseResult.setSkipped(testResult.getSkipCount() > 0);
        testCaseResult.setDuration(testResult.getDuration());
        testCaseResult.setUniqueName(testResult.getId());
        if (testResult.getSkipCount() > 0) {
            testCaseResult.setStatus(TestStatus.SKIPPED);
        } else if (testResult.getFailCount() > 0) {
            testCaseResult.setStatus(TestStatus.FAILURE);
        } else {
            testCaseResult.setStatus(TestStatus.PASSED);
        }
        testCaseResult.setFailedSince(testResult.getFailedSince());
        if (testCaseResult.getStatus() == TestStatus.FAILURE) {
            this.updateErrorDetails(testResult, testCaseResult);
        }
        if ((parent = testResult.getParent()) != null) {
            testCaseResult.setGroupName(parent.getName());
        }
        return testCaseResult;
    }

    private void updateErrorDetails(TestResult testResult, TestCaseResult testCaseResult) {
        try {
            Result result = (Result)FieldUtils.readField((Object)testResult, (String)"result", (boolean)true);
            String errorMessage = result.getErrorMessage();
            if (errorMessage != null) {
                int idx = errorMessage.indexOf(": ");
                int n = idx = idx > 0 ? idx : errorMessage.indexOf("\n");
                if (idx == -1) {
                    idx = Math.min(80, errorMessage.length());
                }
                testCaseResult.setErrorDetails(errorMessage.substring(0, idx));
                testCaseResult.setErrorStackTrace(errorMessage);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private String getStepName(StepResult stepResult) {
        Object stepName = "";
        try {
            Step step = (Step)FieldUtils.readField((Object)stepResult, (String)"step", (boolean)true);
            stepName = step.getKeyword() + " " + step.getName();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return stepName;
    }
}

