/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.HealthReportingAction;
import hudson.model.Run;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.tiger_types.Types;

public abstract class CoverageMetricsAdapter<M extends HealthReportingAction>
implements ExtensionPoint {
    public final Class<M> targetType;
    static final String PERCENTAGE_SUFFIX = "_percentage";
    static final String TOTAL_SUFFIX = "_total";
    static final String COVERED_SUFFIX = "_covered";

    public CoverageMetricsAdapter() {
        Type type = Types.getBaseClass(this.getClass(), CoverageMetricsAdapter.class);
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " uses the raw type for extending CoverageMetricsAdapter");
        }
        this.targetType = Types.erasure((Type)Types.getTypeArgument((Type)type, (int)0));
    }

    public M getAction(Run run) {
        return (M)((HealthReportingAction)run.getAction(this.targetType));
    }

    public boolean isApplicable(Run build) {
        return this.getAction(build) != null;
    }

    @NonNull
    public static Map<Metric, Integer> getMetrics(Run build) {
        ExtensionList adapters = ExtensionList.lookup(CoverageMetricsAdapter.class);
        for (CoverageMetricsAdapter adapter : adapters) {
            if (!adapter.isApplicable(build)) continue;
            return adapter.getMetrics(adapter.getAction(build));
        }
        return Collections.EMPTY_MAP;
    }

    public abstract Map<Metric, Integer> getMetrics(M var1);

    public abstract List<CoverageDetail> getReport(M var1);

    public static List<List<CoverageDetail>> getReport(Run build, int pageSize) {
        ExtensionList adapters = ExtensionList.lookup(CoverageMetricsAdapter.class);
        ArrayList<CoverageDetail> reports = new ArrayList<CoverageDetail>();
        for (CoverageMetricsAdapter adapter : adapters) {
            if (!adapter.isApplicable(build)) continue;
            reports.addAll(adapter.getReport(adapter.getAction(build)));
        }
        if (reports.isEmpty()) {
            return Collections.emptyList();
        }
        if (pageSize == 0 || reports.size() <= pageSize) {
            return Arrays.asList(reports);
        }
        return Lists.partition(reports, (int)pageSize);
    }

    public static class CoverageDetail {
        Map<String, Object> report = new HashMap<String, Object>();

        public CoverageDetail(String name) {
            this.report.put("name", name);
        }

        public CoverageDetail(String name, CoverageLevel level) {
            this.report.put("name", name);
            this.report.put("cov_level", level.toString().toLowerCase());
        }

        public Map<String, Object> getReport() {
            return this.report;
        }

        public void add(Metric metric, int value) {
            this.report.put(metric.toString(), value);
        }

        public void add(String metric, int value) {
            Metric reportMetric = Metric.getMetric(metric);
            if (reportMetric != null) {
                this.report.put(reportMetric.toString(), value);
            } else {
                this.report.put(metric, value);
            }
        }

        public void putAll(Map<Metric, Integer> subReport) {
            for (Map.Entry<Metric, Integer> entry : subReport.entrySet()) {
                this.report.put(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public static enum CoverageLevel {
        PROJECT,
        PACKAGE,
        CLASS,
        METHOD,
        FILE;

    }

    public static enum Metric {
        PACKAGE("packages"),
        FILE("files"),
        CLASS("classes"),
        METHOD("methods"),
        CONDITIONAL("conditionals"),
        STATEMENT("statements"),
        LINE("lines"),
        ELEMENT("elements"),
        COMPLEXITY("complexity"),
        BRANCH("branches"),
        INSTRUCTION("instructions");

        private String description;

        private Metric(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static Metric getMetric(String name) {
            for (Metric metric : Metric.values()) {
                String metricsName = metric.name();
                if (!metricsName.equals(name) && !name.startsWith(metricsName)) continue;
                return metric;
            }
            return null;
        }
    }
}

