/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.CoverageMetricsAdapter;
import hudson.Extension;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Extension(optional=true)
public class CoberturaCoverageMetrics
extends CoverageMetricsAdapter<CoberturaBuildAction> {
    private static List<CoverageElement> TOP_LEVELS = Arrays.asList(CoverageElement.PROJECT, CoverageElement.JAVA_PACKAGE, CoverageElement.JAVA_FILE);

    @Override
    public Map<CoverageMetricsAdapter.Metric, Integer> getMetrics(CoberturaBuildAction coverageAction) {
        return this.extract(coverageAction.getResult());
    }

    private Map<CoverageMetricsAdapter.Metric, Integer> extract(CoverageResult coverageResult) {
        HashMap<CoverageMetricsAdapter.Metric, Integer> result = new HashMap<CoverageMetricsAdapter.Metric, Integer>();
        Set metrics = coverageResult.getMetrics();
        for (CoverageMetric metric : metrics) {
            CoverageMetricsAdapter.Metric reportMetric = CoverageMetricsAdapter.Metric.getMetric(metric.name());
            if (reportMetric == null) continue;
            Ratio ratio = coverageResult.getCoverage(metric);
            if (!(ratio.denominator > 0.0f)) continue;
            int percentage = ratio.getPercentage();
            result.put(reportMetric, percentage);
        }
        return result;
    }

    private void appendDetail(CoverageMetricsAdapter.CoverageDetail detail, CoverageResult coverageResult) {
        Set metrics = coverageResult.getMetrics();
        for (CoverageMetric metric : metrics) {
            CoverageMetricsAdapter.Metric reportMetric = CoverageMetricsAdapter.Metric.getMetric(metric.name());
            if (reportMetric == null) continue;
            Ratio ratio = coverageResult.getCoverage(metric);
            if (!(ratio.denominator > 0.0f)) continue;
            detail.add(String.valueOf((Object)reportMetric) + "_percentage", ratio.getPercentage());
            detail.add(String.valueOf((Object)reportMetric) + "_total", (int)ratio.denominator);
            detail.add(String.valueOf((Object)reportMetric) + "_covered", (int)ratio.numerator);
        }
    }

    @Override
    public List<CoverageMetricsAdapter.CoverageDetail> getReport(CoberturaBuildAction coverageAction) {
        CoverageResult coverageResult = coverageAction.getResult();
        return this.getReport(coverageResult, "");
    }

    private List<CoverageMetricsAdapter.CoverageDetail> getReport(CoverageResult coverage, String prefix) {
        CoverageMetricsAdapter.CoverageLevel level;
        ArrayList<CoverageMetricsAdapter.CoverageDetail> report = new ArrayList<CoverageMetricsAdapter.CoverageDetail>();
        prefix = prefix == null ? "" : prefix;
        Object coverageName = prefix + coverage.getName();
        Object childPrefix = prefix;
        switch (coverage.getElement()) {
            case JAVA_FILE: {
                level = CoverageMetricsAdapter.CoverageLevel.FILE;
                break;
            }
            case JAVA_PACKAGE: {
                level = CoverageMetricsAdapter.CoverageLevel.PACKAGE;
                childPrefix = (String)coverageName + ".";
                break;
            }
            case PROJECT: {
                level = CoverageMetricsAdapter.CoverageLevel.PROJECT;
                coverageName = "project";
                break;
            }
            case JAVA_METHOD: {
                level = CoverageMetricsAdapter.CoverageLevel.METHOD;
                break;
            }
            case JAVA_CLASS: {
                level = CoverageMetricsAdapter.CoverageLevel.CLASS;
                childPrefix = (String)coverageName + "#";
                break;
            }
            default: {
                level = CoverageMetricsAdapter.CoverageLevel.PACKAGE;
            }
        }
        CoverageMetricsAdapter.CoverageDetail detail = new CoverageMetricsAdapter.CoverageDetail((String)coverageName, level);
        this.appendDetail(detail, coverage);
        report.add(detail);
        Map children = coverage.getChildrenReal();
        if (children == null || children.isEmpty()) {
            return report;
        }
        for (CoverageResult child : children.values()) {
            report.addAll(this.getReport(child, (String)childPrefix));
        }
        return report;
    }
}

