/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class WebPostAccessLogger
implements Filter {
    private static final Logger LOG = Logger.getLogger(WebPostAccessLogger.class.getName());
    private static final Pattern FILTER_PATTERN = Pattern.compile("/(?:configSubmit|updateSubmit|script|doDelete)");

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("splunk-filter loaded");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.loggerUserAction(servletRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void loggerUserAction(ServletRequest servletRequest) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.JENKINS_CONFIG)) {
            return;
        }
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!"POST".equals(request.getMethod())) {
            return;
        }
        Authentication auth = Jenkins.getAuthentication();
        String path = request.getRequestURI();
        if (auth == null || path == null || !auth.isAuthenticated()) {
            return;
        }
        if (!FILTER_PATTERN.matcher(path).find()) {
            return;
        }
        HashMap<String, Object> auditInfo = new HashMap<String, Object>();
        auditInfo.put("user", auth.getName());
        auditInfo.put("message", "POST " + request.getRequestURI());
        auditInfo.put("event_tag", "audit_trail");
        SplunkLogService.getInstance().send(auditInfo, EventType.JENKINS_CONFIG, "web_access");
    }

    public void destroy() {
    }
}

