// CHECKSTYLE:OFF

package com.splunk.splunkjenkins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ValueCannotBeBlank}: {@code This value cannot be blank.}.
     * 
     * @return
     *     {@code This value cannot be blank.}
     */
    public static String ValueCannotBeBlank() {
        return holder.format("ValueCannotBeBlank");
    }

    /**
     * Key {@code ValueCannotBeBlank}: {@code This value cannot be blank.}.
     * 
     * @return
     *     {@code This value cannot be blank.}
     */
    public static Localizable _ValueCannotBeBlank() {
        return new Localizable(holder, "ValueCannotBeBlank");
    }

    /**
     * Key {@code Description}: {@code A Splunk-Jenkins plugin for Splunking

     * Jenkins.}.
     * 
     * @return
     *     {@code A Splunk-Jenkins plugin for Splunking Jenkins.}
     */
    public static String Description() {
        return holder.format("Description");
    }

    /**
     * Key {@code Description}: {@code A Splunk-Jenkins plugin for Splunking

     * Jenkins.}.
     * 
     * @return
     *     {@code A Splunk-Jenkins plugin for Splunking Jenkins.}
     */
    public static Localizable _Description() {
        return new Localizable(holder, "Description");
    }

    /**
     * Key {@code HostNameSchemaWarning}: {@code Invalid hostname, do you

     * mean {0}?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid hostname, do you mean {0}?}
     */
    public static String HostNameSchemaWarning(Object arg0) {
        return holder.format("HostNameSchemaWarning", arg0);
    }

    /**
     * Key {@code HostNameSchemaWarning}: {@code Invalid hostname, do you

     * mean {0}?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid hostname, do you mean {0}?}
     */
    public static Localizable _HostNameSchemaWarning(Object arg0) {
        return new Localizable(holder, "HostNameSchemaWarning", arg0);
    }

    /**
     * Key {@code PluginViewPermission.Description}: {@code This permission

     * grants access to the Splunk Instance Link.}.
     * 
     * @return
     *     {@code This permission grants access to the Splunk Instance Link.}
     */
    public static String PluginViewPermission_Description() {
        return holder.format("PluginViewPermission.Description");
    }

    /**
     * Key {@code PluginViewPermission.Description}: {@code This permission

     * grants access to the Splunk Instance Link.}.
     * 
     * @return
     *     {@code This permission grants access to the Splunk Instance Link.}
     */
    public static Localizable _PluginViewPermission_Description() {
        return new Localizable(holder, "PluginViewPermission.Description");
    }

    /**
     * Key {@code PermissionGroup}: {@code Splunk}.
     * 
     * @return
     *     {@code Splunk}
     */
    public static String PermissionGroup() {
        return holder.format("PermissionGroup");
    }

    /**
     * Key {@code PermissionGroup}: {@code Splunk}.
     * 
     * @return
     *     {@code Splunk}
     */
    public static Localizable _PermissionGroup() {
        return new Localizable(holder, "PermissionGroup");
    }

    /**
     * Key {@code ConfigBuildStepTitle}: {@code Send data to Splunk}.
     * 
     * @return
     *     {@code Send data to Splunk}
     */
    public static String ConfigBuildStepTitle() {
        return holder.format("ConfigBuildStepTitle");
    }

    /**
     * Key {@code ConfigBuildStepTitle}: {@code Send data to Splunk}.
     * 
     * @return
     *     {@code Send data to Splunk}
     */
    public static Localizable _ConfigBuildStepTitle() {
        return new Localizable(holder, "ConfigBuildStepTitle");
    }

    /**
     * Key {@code HostNameListWarning}: {@code Multiple hosts is not

     * supported, please setup load balancer, and user the virtual name}.
     * 
     * @return
     *     {@code Multiple hosts is not supported, please setup load balancer,

     *     and user the virtual name}
     */
    public static String HostNameListWarning() {
        return holder.format("HostNameListWarning");
    }

    /**
     * Key {@code HostNameListWarning}: {@code Multiple hosts is not

     * supported, please setup load balancer, and user the virtual name}.
     * 
     * @return
     *     {@code Multiple hosts is not supported, please setup load balancer,

     *     and user the virtual name}
     */
    public static Localizable _HostNameListWarning() {
        return new Localizable(holder, "HostNameListWarning");
    }

    /**
     * Key {@code PleaseProvideHost}: {@code Please provide the hostname to a

     * Splunk instance.}.
     * 
     * @return
     *     {@code Please provide the hostname to a Splunk instance.}
     */
    public static String PleaseProvideHost() {
        return holder.format("PleaseProvideHost");
    }

    /**
     * Key {@code PleaseProvideHost}: {@code Please provide the hostname to a

     * Splunk instance.}.
     * 
     * @return
     *     {@code Please provide the hostname to a Splunk instance.}
     */
    public static Localizable _PleaseProvideHost() {
        return new Localizable(holder, "PleaseProvideHost");
    }

    /**
     * Key {@code ConfigBuildFileToAppend}: {@code File to append to event}.
     * 
     * @return
     *     {@code File to append to event}
     */
    public static String ConfigBuildFileToAppend() {
        return holder.format("ConfigBuildFileToAppend");
    }

    /**
     * Key {@code ConfigBuildFileToAppend}: {@code File to append to event}.
     * 
     * @return
     *     {@code File to append to event}
     */
    public static Localizable _ConfigBuildFileToAppend() {
        return new Localizable(holder, "ConfigBuildFileToAppend");
    }

    /**
     * Key {@code SplunArtifactArchive}: {@code Send files to Splunk}.
     * 
     * @return
     *     {@code Send files to Splunk}
     */
    public static String SplunArtifactArchive() {
        return holder.format("SplunArtifactArchive");
    }

    /**
     * Key {@code SplunArtifactArchive}: {@code Send files to Splunk}.
     * 
     * @return
     *     {@code Send files to Splunk}
     */
    public static Localizable _SplunArtifactArchive() {
        return new Localizable(holder, "SplunArtifactArchive");
    }

    /**
     * Key {@code InvalidPattern}: {@code The pattern is invalid, please

     * check <a

     * href="https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html">Pattern</a>}.
     * 
     * @return
     *     {@code The pattern is invalid, please check <a

     *     href="https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html">Pattern</a>}
     */
    public static String InvalidPattern() {
        return holder.format("InvalidPattern");
    }

    /**
     * Key {@code InvalidPattern}: {@code The pattern is invalid, please

     * check <a

     * href="https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html">Pattern</a>}.
     * 
     * @return
     *     {@code The pattern is invalid, please check <a

     *     href="https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html">Pattern</a>}
     */
    public static Localizable _InvalidPattern() {
        return new Localizable(holder, "InvalidPattern");
    }

    /**
     * Key {@code SplunkIconName}: {@code

     * /plugin/splunk-devops/images/splunk_logo_green.png}.
     * 
     * @return
     *     {@code /plugin/splunk-devops/images/splunk_logo_green.png}
     */
    public static String SplunkIconName() {
        return holder.format("SplunkIconName");
    }

    /**
     * Key {@code SplunkIconName}: {@code

     * /plugin/splunk-devops/images/splunk_logo_green.png}.
     * 
     * @return
     *     {@code /plugin/splunk-devops/images/splunk_logo_green.png}
     */
    public static Localizable _SplunkIconName() {
        return new Localizable(holder, "SplunkIconName");
    }

    /**
     * Key {@code ValueIntErrorMsg}: {@code This value must be a valid int.}.
     * 
     * @return
     *     {@code This value must be a valid int.}
     */
    public static String ValueIntErrorMsg() {
        return holder.format("ValueIntErrorMsg");
    }

    /**
     * Key {@code ValueIntErrorMsg}: {@code This value must be a valid int.}.
     * 
     * @return
     *     {@code This value must be a valid int.}
     */
    public static Localizable _ValueIntErrorMsg() {
        return new Localizable(holder, "ValueIntErrorMsg");
    }

    /**
     * Key {@code ConfigBuildStepSendEnvVars}: {@code Send environment

     * variables}.
     * 
     * @return
     *     {@code Send environment variables}
     */
    public static String ConfigBuildStepSendEnvVars() {
        return holder.format("ConfigBuildStepSendEnvVars");
    }

    /**
     * Key {@code ConfigBuildStepSendEnvVars}: {@code Send environment

     * variables}.
     * 
     * @return
     *     {@code Send environment variables}
     */
    public static Localizable _ConfigBuildStepSendEnvVars() {
        return new Localizable(holder, "ConfigBuildStepSendEnvVars");
    }

    /**
     * Key {@code CloudHostPrefix}: {@code You are using Splunk Cloud, please

     * provide host name starts input- or http-inputs-, please try input-{0}

     * or http-inputs-{0}. See also

     * http://dev.splunk.com/view/event-collector/SP-CAAAE7G}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You are using Splunk Cloud, please provide host name starts

     *     input- or http-inputs-, please try input-{0} or http-inputs-{0}. See

     *     also http://dev.splunk.com/view/event-collector/SP-CAAAE7G}
     */
    public static String CloudHostPrefix(Object arg0) {
        return holder.format("CloudHostPrefix", arg0);
    }

    /**
     * Key {@code CloudHostPrefix}: {@code You are using Splunk Cloud, please

     * provide host name starts input- or http-inputs-, please try input-{0}

     * or http-inputs-{0}. See also

     * http://dev.splunk.com/view/event-collector/SP-CAAAE7G}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You are using Splunk Cloud, please provide host name starts

     *     input- or http-inputs-, please try input-{0} or http-inputs-{0}. See

     *     also http://dev.splunk.com/view/event-collector/SP-CAAAE7G}
     */
    public static Localizable _CloudHostPrefix(Object arg0) {
        return new Localizable(holder, "CloudHostPrefix", arg0);
    }

    /**
     * Key {@code InvalidHostOrToken}: {@code Invalid config, please check

     * Hostname or Token}.
     * 
     * @return
     *     {@code Invalid config, please check Hostname or Token}
     */
    public static String InvalidHostOrToken() {
        return holder.format("InvalidHostOrToken");
    }

    /**
     * Key {@code InvalidHostOrToken}: {@code Invalid config, please check

     * Hostname or Token}.
     * 
     * @return
     *     {@code Invalid config, please check Hostname or Token}
     */
    public static Localizable _InvalidHostOrToken() {
        return new Localizable(holder, "InvalidHostOrToken");
    }

    /**
     * Key {@code ConfigBuildStepSendFiles}: {@code Files to send as an

     * event}.
     * 
     * @return
     *     {@code Files to send as an event}
     */
    public static String ConfigBuildStepSendFiles() {
        return holder.format("ConfigBuildStepSendFiles");
    }

    /**
     * Key {@code ConfigBuildStepSendFiles}: {@code Files to send as an

     * event}.
     * 
     * @return
     *     {@code Files to send as an event}
     */
    public static Localizable _ConfigBuildStepSendFiles() {
        return new Localizable(holder, "ConfigBuildStepSendFiles");
    }

    /**
     * Key {@code DisplayName}: {@code Splunk-Jenkins}.
     * 
     * @return
     *     {@code Splunk-Jenkins}
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Key {@code DisplayName}: {@code Splunk-Jenkins}.
     * 
     * @return
     *     {@code Splunk-Jenkins}
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Key {@code InvalidToken}: {@code Token is invalid}.
     * 
     * @return
     *     {@code Token is invalid}
     */
    public static String InvalidToken() {
        return holder.format("InvalidToken");
    }

    /**
     * Key {@code InvalidToken}: {@code Token is invalid}.
     * 
     * @return
     *     {@code Token is invalid}
     */
    public static Localizable _InvalidToken() {
        return new Localizable(holder, "InvalidToken");
    }

    /**
     * Key {@code HostNameInvalid}: {@code Failed to validate hostname}.
     * 
     * @return
     *     {@code Failed to validate hostname}
     */
    public static String HostNameInvalid() {
        return holder.format("HostNameInvalid");
    }

    /**
     * Key {@code HostNameInvalid}: {@code Failed to validate hostname}.
     * 
     * @return
     *     {@code Failed to validate hostname}
     */
    public static Localizable _HostNameInvalid() {
        return new Localizable(holder, "HostNameInvalid");
    }

    /**
     * Key {@code ConfigBuildStepSendLog}: {@code Send build log}.
     * 
     * @return
     *     {@code Send build log}
     */
    public static String ConfigBuildStepSendLog() {
        return holder.format("ConfigBuildStepSendLog");
    }

    /**
     * Key {@code ConfigBuildStepSendLog}: {@code Send build log}.
     * 
     * @return
     *     {@code Send build log}
     */
    public static Localizable _ConfigBuildStepSendLog() {
        return new Localizable(holder, "ConfigBuildStepSendLog");
    }

}
