/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.splunk.splunkjenkins.console.ConsoleNoteHandler;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import hudson.MarkupText;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class LabelMarkupText
extends MarkupText {
    private static final Boolean isDisabled = Boolean.getBoolean(LogEventHelper.class.getName() + ".disableLabelMarkup");
    private static final String PARALLEL_BRANCH_LABEL = "Branch: ";
    private static final Logger LOG = Logger.getLogger(LabelMarkupText.class.getName());
    private static final String PARALLEL_LABEL = "parallel_label";
    private String encloseLabel = null;
    private SoftReference<Map<String, String>> encloseLabelRef = new SoftReference(new HashMap());
    private String annotation = null;
    private Object lock = new Object();

    public LabelMarkupText() {
        super("");
    }

    public void addMarkup(int startPos, int endPos, String startTag, String endTag) {
        if (isDisabled.booleanValue()) {
            return;
        }
        this.parseTagLabel(startTag + endTag);
    }

    private void parseTagLabel(String tag) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(tag);
        }
        this.annotation = "";
        try {
            ConsoleNoteHandler handler = new ConsoleNoteHandler();
            handler.read(tag);
            String href = handler.getHref();
            if (StringUtils.isNotEmpty((String)href)) {
                this.annotation = "href=" + href;
                return;
            }
            String nodeId = handler.getNodeId();
            if (StringUtils.isNotEmpty((String)nodeId)) {
                Map<String, String> encloseLabels = this.encloseLabelRef.get();
                if (encloseLabels == null) {
                    return;
                }
                if (handler.getStartId() != null) {
                    this.encloseLabel = null;
                    String label = handler.getLabel();
                    if (StringUtils.startsWith((String)label, (String)PARALLEL_BRANCH_LABEL)) {
                        encloseLabels.put(nodeId, label.substring(PARALLEL_BRANCH_LABEL.length()));
                    }
                } else {
                    String enclosingId = handler.getEnclosingId();
                    if (StringUtils.isNotEmpty((String)enclosingId)) {
                        String nodeLabel = encloseLabels.get(enclosingId);
                        if (nodeLabel != null) {
                            encloseLabels.put(nodeId, nodeLabel);
                            this.encloseLabel = "parallel_label=\"" + StringEscapeUtils.escapeJava((String)nodeLabel) + "\"";
                        } else {
                            this.encloseLabel = null;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warning("failed to parse html console note " + tag + " exception:" + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        if (isDisabled.booleanValue()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (StringUtils.isNotEmpty((String)this.annotation)) {
                out.write(this.annotation.getBytes(StandardCharsets.UTF_8));
                out.write(32);
                this.annotation = "";
            }
        }
    }

    public void writePreviousLabel(OutputStream out) throws IOException {
        if (StringUtils.isNotEmpty((String)this.encloseLabel)) {
            out.write(this.encloseLabel.getBytes(StandardCharsets.UTF_8));
            out.write(32);
        }
    }
}

