/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.version;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionNumber;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.HighestVersionNumber;
import hudson.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritVersionChecker {
    private static final Logger logger = LoggerFactory.getLogger(GerritVersionChecker.class);

    private GerritVersionChecker() {
    }

    public static boolean isCorrectVersion(Feature feature) {
        GerritVersionNumber gerritVersion = GerritVersionChecker.createVersionNumber(PluginImpl.getInstance().getGerritVersion());
        return GerritVersionChecker.isCorrectVersion(gerritVersion, feature);
    }

    public static boolean isCorrectVersion(GerritVersionNumber gerritVersion, Feature feature) {
        return gerritVersion.isSnapshot() || !feature.versionNumber.isNewerThan((VersionNumber)gerritVersion);
    }

    public static GerritVersionNumber createVersionNumber(String version) {
        if (version == null || version.equals("")) {
            logger.error("Gerrit version number is null or the empty string.");
            return new HighestVersionNumber();
        }
        return GerritVersionNumber.getGerritVersionNumber(version);
    }

    public static enum Feature {
        fileTrigger("Trigger on files", "2.3"),
        triggerOnDraftPublished("Trigger on draft published", "2.5");

        private final String displayName;
        private final String version;
        private final VersionNumber versionNumber;

        private Feature(String displayName, String version) {
            this.displayName = displayName;
            this.version = version;
            this.versionNumber = new VersionNumber(version);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

