/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class PluginCommentAddedEvent
extends PluginGerritEvent
implements Serializable {
    private String verdictCategory;
    private String commentAddedTriggerApprovalValue;

    @DataBoundConstructor
    public PluginCommentAddedEvent(String verdictCategory, String commentAddedTriggerApprovalValue) {
        this.verdictCategory = verdictCategory;
        this.commentAddedTriggerApprovalValue = commentAddedTriggerApprovalValue;
    }

    public PluginCommentAddedEvent() {
    }

    public String getCommentAddedTriggerApprovalValue() {
        return this.commentAddedTriggerApprovalValue;
    }

    public String getVerdictCategory() {
        return this.verdictCategory;
    }

    public Descriptor<PluginGerritEvent> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(PluginCommentAddedEventDescriptor.class);
    }

    @Override
    public Class getCorrespondingEventClass() {
        return CommentAdded.class;
    }

    @Extension
    public static class PluginCommentAddedEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.CommentAddedDisplayName();
        }

        public ListBoxModel doFillVerdictCategoryItems() {
            ListBoxModel m = new ListBoxModel();
            List<VerdictCategory> list = PluginImpl.getInstance().getConfig().getCategories();
            if (list != null && !list.isEmpty()) {
                for (VerdictCategory v : list) {
                    m.add(v.getVerdictDescription(), v.getVerdictValue());
                }
            }
            return m;
        }
    }
}

