/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;

public class TriggeredItemEntity {
    private Integer buildNumber;
    private String projectId;
    private transient AbstractProject project;
    private transient AbstractBuild build;

    public TriggeredItemEntity(Integer buildNumber, String projectId) {
        this.buildNumber = buildNumber;
        this.projectId = projectId;
    }

    public TriggeredItemEntity(AbstractProject project, AbstractBuild build) {
        this.setProject(project);
        this.setBuild(build);
    }

    public TriggeredItemEntity(AbstractBuild build) {
        this.setProject(build.getProject());
        this.setBuild(build);
    }

    public TriggeredItemEntity(AbstractProject project) {
        this.setProject(project);
        this.buildNumber = null;
    }

    public TriggeredItemEntity() {
    }

    public boolean hasBuild() {
        return this.buildNumber != null;
    }

    public AbstractBuild getBuild() {
        if (this.build == null && this.buildNumber != null) {
            this.getProject();
            if (this.project != null) {
                this.build = (AbstractBuild)this.project.getBuildByNumber(this.buildNumber.intValue());
            }
        }
        return this.build;
    }

    public void setBuild(AbstractBuild build) {
        this.build = build;
        this.buildNumber = build.getNumber();
    }

    public AbstractProject getProject() {
        if (this.project == null) {
            this.project = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectId, AbstractProject.class);
        }
        return this.project;
    }

    public void setProject(AbstractProject project) {
        this.project = project;
        this.projectId = project.getFullName();
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggeredItemEntity other = (TriggeredItemEntity)obj;
        if (!(this.buildNumber == other.buildNumber || this.buildNumber != null && this.buildNumber.equals(other.buildNumber))) {
            return false;
        }
        return !(this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId));
    }

    public boolean equals(AbstractBuild aBuild) {
        if (this.buildNumber != null) {
            return this.projectId.equals(aBuild.getProject().getFullName()) && this.buildNumber.equals(aBuild.getNumber());
        }
        return false;
    }

    public boolean equals(AbstractProject aProject) {
        return this.projectId.equals(aProject.getFullName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.buildNumber != null ? this.buildNumber.hashCode() : 0);
        hash = 47 * hash + (this.projectId != null ? this.projectId.hashCode() : 0);
        return hash;
    }
}

