/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.LinkedList;
import java.util.List;

public class TriggerContext {
    private GerritTriggeredEvent event;
    private TriggeredItemEntity thisBuild;
    private List<TriggeredItemEntity> others;

    public TriggerContext(AbstractBuild thisBuild, GerritTriggeredEvent event, List<TriggeredItemEntity> others) {
        this.thisBuild = new TriggeredItemEntity(thisBuild);
        this.event = event;
        this.others = others;
    }

    public TriggerContext(GerritTriggeredEvent event) {
        this.event = event;
    }

    public TriggerContext() {
    }

    public synchronized List<TriggeredItemEntity> getOthers() {
        return this.others;
    }

    public synchronized void setOthers(List<TriggeredItemEntity> otherBuilds) {
        this.others = otherBuilds;
    }

    public synchronized TriggeredItemEntity getThisBuild() {
        return this.thisBuild;
    }

    public synchronized void setThisBuild(TriggeredItemEntity thisBuild) {
        this.thisBuild = thisBuild;
    }

    public synchronized void setThisBuild(AbstractBuild thisBuild) {
        this.thisBuild = new TriggeredItemEntity(thisBuild);
    }

    public GerritTriggeredEvent getEvent() {
        return this.event;
    }

    void setEvent(GerritTriggeredEvent event) {
        this.event = event;
    }

    public synchronized void addOtherBuild(AbstractBuild build) {
        TriggeredItemEntity other;
        if (this.others == null) {
            this.others = new LinkedList<TriggeredItemEntity>();
        }
        if ((other = this.findOtherBuild(build)) == null) {
            other = this.findOtherProject(build.getProject());
            if (other != null) {
                other.setBuild(build);
            } else {
                this.others.add(new TriggeredItemEntity(build));
            }
        }
    }

    public synchronized void addOtherProject(AbstractProject project) {
        if (this.others == null) {
            this.others = new LinkedList<TriggeredItemEntity>();
        }
        if (this.findOtherProject(project) == null) {
            this.others.add(new TriggeredItemEntity(project));
        }
    }

    public synchronized boolean hasOthers() {
        return this.others != null && !this.others.isEmpty();
    }

    private synchronized TriggeredItemEntity findOtherBuild(AbstractBuild build) {
        for (TriggeredItemEntity other : this.others) {
            if (!other.equals(build)) continue;
            return other;
        }
        return null;
    }

    private synchronized TriggeredItemEntity findOtherProject(AbstractProject project) {
        for (TriggeredItemEntity other : this.others) {
            if (!other.equals(project)) continue;
            return other;
        }
        return null;
    }

    public synchronized List<AbstractBuild> getOtherBuilds() {
        LinkedList<AbstractBuild> list = new LinkedList<AbstractBuild>();
        if (this.others != null) {
            for (TriggeredItemEntity entity : this.others) {
                if (entity.getBuild() == null) continue;
                list.add(entity.getBuild());
            }
        }
        return list;
    }

    public synchronized List<AbstractProject> getOtherProjects() {
        LinkedList<AbstractProject> list = new LinkedList<AbstractProject>();
        if (this.others != null) {
            for (TriggeredItemEntity entity : this.others) {
                if (entity.getProject() == null) continue;
                list.add(entity.getProject());
            }
        }
        return list;
    }
}

