/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Branch;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.FilePath;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.ComboBoxModel;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class GerritProject
implements Describable<GerritProject> {
    private CompareType compareType;
    private String pattern;
    private List<Branch> branches;
    private List<FilePath> filePaths;

    public GerritProject() {
    }

    @DataBoundConstructor
    public GerritProject(CompareType compareType, String pattern, List<Branch> branches, List<FilePath> filePaths) {
        this.compareType = compareType;
        this.pattern = pattern;
        this.branches = branches;
        this.filePaths = filePaths;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public List<FilePath> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(List<FilePath> filePaths) {
        this.filePaths = filePaths;
    }

    public boolean isInteresting(String project, String branch, List<String> files) {
        if (this.compareType.matches(this.pattern, project)) {
            for (Branch b : this.branches) {
                if (!b.isInteresting(branch)) continue;
                for (FilePath f : this.filePaths) {
                    if (!f.isInteresting(files)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isInteresting(String project, String branch) {
        if (this.compareType.matches(this.pattern, project)) {
            for (Branch b : this.branches) {
                if (!b.isInteresting(branch)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Descriptor<GerritProject> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GerritProject> {
        public ComboBoxModel doFillPatternItems() {
            return new ComboBoxModel(PluginImpl.getInstance().getGerritProjects());
        }

        public String getDisplayName() {
            return null;
        }
    }
}

