/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.manual;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.lifecycle.GerritEventLifecycleListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.Result;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TriggerMonitor
implements GerritEventLifecycleListener {
    private List<EventState> events = new LinkedList<EventState>();

    public synchronized void add(PatchsetCreated event) {
        if (!this.contains(event)) {
            event.addListener((GerritEventLifecycleListener)this);
            this.events.add(new EventState(event));
        }
    }

    public synchronized boolean contains(PatchsetCreated event) {
        for (EventState state : this.events) {
            if (state.event == null || !state.event.equals((Object)event)) continue;
            return true;
        }
        return false;
    }

    private synchronized EventState findState(PatchsetCreated event) {
        for (EventState state : this.events) {
            if (state.event == null || !state.event.equals((Object)event)) continue;
            return state;
        }
        return null;
    }

    public synchronized void triggerScanStarting(PatchsetCreated event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.triggerScanStarted = true;
        }
    }

    public synchronized void triggerScanDone(PatchsetCreated event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.triggerScanDone = true;
        }
    }

    public synchronized void projectTriggered(PatchsetCreated event, AbstractProject project) {
        EventState state = this.findState(event);
        if (state != null) {
            state.addProject(project);
        }
    }

    public synchronized void buildStarted(PatchsetCreated event, AbstractBuild build) {
        EventState state = this.findState(event);
        if (state != null) {
            state.setBuild(build);
        }
    }

    public synchronized void buildCompleted(PatchsetCreated event, AbstractBuild build) {
        EventState state = this.findState(event);
        if (state != null && state.allBuildsCompleted && state.isReallyAllBuildsCompleted()) {
            event.removeListener((GerritEventLifecycleListener)this);
        }
    }

    public synchronized void allBuildsCompleted(PatchsetCreated event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.allBuildsCompleted = true;
            if (state.isReallyAllBuildsCompleted()) {
                event.removeListener((GerritEventLifecycleListener)this);
            }
        }
    }

    public synchronized List<EventState> getEvents() {
        return this.events;
    }

    public synchronized Iterator<EventState> getEventsIterator() {
        return this.events.iterator();
    }

    public static class EventState {
        private PatchsetCreated event;
        private boolean triggerScanStarted = false;
        private boolean triggerScanDone = false;
        private boolean allBuildsCompleted = false;
        private List<TriggeredItemEntity> builds;

        EventState(PatchsetCreated event) {
            this.event = event;
            this.builds = new LinkedList<TriggeredItemEntity>();
        }

        void addProject(AbstractProject project) {
            this.builds.add(new TriggeredItemEntity(project));
        }

        void setBuild(AbstractBuild build) {
            for (TriggeredItemEntity entity : this.builds) {
                if (!entity.equals(build.getProject())) continue;
                entity.setBuild(build);
            }
        }

        public String getBallColor() {
            if (!this.triggerScanStarted) {
                return BallColor.GREY.getImage();
            }
            if (!this.triggerScanDone) {
                return BallColor.GREY_ANIME.getImage();
            }
            if (this.isUnTriggered()) {
                return BallColor.DISABLED.getImage();
            }
            Result result = this.getLeastFavorableResult();
            if (result != null) {
                return result.color.getImage();
            }
            return BallColor.GREY_ANIME.getImage();
        }

        private Result getLeastFavorableResult() {
            Result least = null;
            for (TriggeredItemEntity entity : this.builds) {
                if (entity.getBuild() == null || entity.getBuild().getResult() == null) continue;
                Result tmp = entity.getBuild().getResult();
                if (least == null) {
                    least = tmp;
                    continue;
                }
                least = least.combine(tmp);
            }
            return least;
        }

        public boolean isUnTriggered() {
            if (!this.triggerScanStarted) {
                return false;
            }
            return this.triggerScanDone && this.builds.size() <= 0;
        }

        public PatchsetCreated getEvent() {
            return this.event;
        }

        public boolean isTriggerScanStarted() {
            return this.triggerScanStarted;
        }

        public boolean isTriggerScanDone() {
            return this.triggerScanDone;
        }

        public boolean isAllBuildsCompleted() {
            return this.allBuildsCompleted;
        }

        public List<TriggeredItemEntity> getBuilds() {
            return this.builds;
        }

        public boolean isReallyAllBuildsCompleted() {
            for (TriggeredItemEntity entity : this.builds) {
                if (entity.getBuild() != null && entity.getBuild().isLogUpdated()) continue;
                return false;
            }
            return true;
        }
    }
}

