/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.manual;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryHandler;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.Change;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerParameters;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.manual.TriggerMonitor;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ManualTriggerAction
implements RootAction {
    public static final int EXPECTED_NR_OF_PARTS_IN_A_GENERATED_ID = 3;
    private static final String SESSION_RESULT = "result";
    private static final String SESSION_SEARCH_ERROR = "error_search";
    private static final String SESSION_BUILD_ERROR = "error_build";
    private static final String SESSION_TRIGGER_MONITOR = "trigger_monitor";
    private static final Logger logger = LoggerFactory.getLogger(ManualTriggerAction.class);
    public static final String ID_SEPARATOR = ":";
    private static final int MAX_SUBJECT_STR_LENGTH = 65;

    public String getIconFileName() {
        if (this.isEnabled() && Hudson.getInstance().hasPermission(PluginImpl.MANUAL_TRIGGER)) {
            return StringUtil.getPluginImageUrl("icon_retrigger24.png");
        }
        return null;
    }

    public String getDisplayName() {
        if (this.isEnabled() && Hudson.getInstance().hasPermission(PluginImpl.MANUAL_TRIGGER)) {
            return Messages.ManualGerritTrigger();
        }
        return null;
    }

    public String getUrlName() {
        return "/gerrit_manual_trigger";
    }

    public boolean isEnabled() {
        if (PluginImpl.getInstance() != null && PluginImpl.getInstance().getConfig() != null) {
            return PluginImpl.getInstance().getConfig().isEnableManualTrigger();
        }
        return false;
    }

    public Permission getRequiredPermission() {
        return PluginImpl.MANUAL_TRIGGER;
    }

    public String getJsUrl(String jsName) {
        return StringUtil.getPluginJsUrl(jsName);
    }

    public HighLow getCodeReview(JSONObject res) {
        return Approval.CODE_REVIEW.getApprovals(res);
    }

    public HighLow getVerified(JSONObject res) {
        return Approval.VERIFIED.getApprovals(res);
    }

    public String toReadableHtml(String subject) {
        if (subject != null && subject.length() > 65) {
            subject = subject.substring(0, 65);
        }
        if (subject != null) {
            return Util.escape((String)subject);
        }
        return "";
    }

    public void doGerritSearch(@QueryParameter(value="queryString") String queryString, StaplerRequest request, StaplerResponse response) throws IOException {
        if (!this.isEnabled()) {
            response.sendRedirect2(".");
            return;
        }
        Hudson.getInstance().checkPermission(PluginImpl.MANUAL_TRIGGER);
        IGerritHudsonTriggerConfig config = PluginImpl.getInstance().getConfig();
        GerritQueryHandler handler = new GerritQueryHandler((GerritConnectionConfig)config);
        this.clearSessionData(request);
        request.getSession(true).setAttribute("queryString", (Object)queryString);
        try {
            List json = handler.queryJava(queryString, true, true, false);
            request.getSession(true).setAttribute(SESSION_RESULT, (Object)json);
        }
        catch (GerritQueryException gqe) {
            logger.debug("Bad query. ", (Throwable)gqe);
            request.getSession(true).setAttribute(SESSION_SEARCH_ERROR, (Object)gqe);
        }
        catch (Exception ex) {
            logger.warn("Could not query Gerrit for [" + queryString + "]", (Throwable)ex);
            request.getSession(true).setAttribute(SESSION_SEARCH_ERROR, (Object)ex);
        }
        response.sendRedirect2(".");
    }

    public void doBuild(@QueryParameter(value="selectedIds") String selectedIds, StaplerRequest request, StaplerResponse response) throws IOException {
        if (!this.isEnabled()) {
            response.sendRedirect2(".");
            return;
        }
        Hudson.getInstance().checkPermission(PluginImpl.MANUAL_TRIGGER);
        request.getSession(true).removeAttribute(SESSION_BUILD_ERROR);
        String[] selectedRows = null;
        if (selectedIds != null && selectedIds.length() > 0) {
            selectedRows = selectedIds.split("\\[\\]");
        }
        if (selectedRows == null || selectedRows.length <= 0) {
            logger.debug("No builds selected.");
            request.getSession(true).setAttribute(SESSION_BUILD_ERROR, (Object)Messages.ErrorSelectSomethingToBuild());
            response.sendRedirect2(".");
        } else {
            logger.debug("Something to build.");
            List result = (List)request.getSession(true).getAttribute(SESSION_RESULT);
            TriggerMonitor monitor = new TriggerMonitor();
            logger.trace("Putting monitor into session.");
            request.getSession(true).setAttribute(SESSION_TRIGGER_MONITOR, (Object)monitor);
            logger.trace("Calling to index the search result.");
            HashMap<String, JSONObject> indexed = this.indexResult(result);
            logger.debug("Creating and triggering events.");
            for (String rowId : selectedRows) {
                ManualPatchsetCreated event = this.findAndCreatePatchSetEvent(rowId, indexed);
                logger.debug("Created event: {}", (Object)event);
                if (event == null) continue;
                monitor.add((PatchsetCreated)event);
                logger.trace("Triggering event: {}", (Object)event);
                this.triggerEvent(event);
            }
            logger.debug("Sending redirect.");
            response.sendRedirect2(".");
        }
    }

    private void clearSessionData(StaplerRequest request) {
        request.getSession(true).removeAttribute(SESSION_SEARCH_ERROR);
        request.getSession(true).removeAttribute(SESSION_BUILD_ERROR);
        request.getSession(true).removeAttribute(SESSION_RESULT);
        request.getSession(true).removeAttribute(SESSION_TRIGGER_MONITOR);
    }

    public String generateTheId(JSONObject change, JSONObject patch) {
        StringBuilder theId = new StringBuilder(change.getString("id"));
        if (patch != null) {
            theId.append(ID_SEPARATOR);
            theId.append(patch.getString("revision"));
        }
        theId.append(ID_SEPARATOR);
        theId.append(change.getString("number"));
        if (patch != null) {
            theId.append(ID_SEPARATOR);
            theId.append(patch.getString("number"));
        }
        return theId.toString();
    }

    private HashMap<String, JSONObject> indexResult(List<JSONObject> result) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (JSONObject res : result) {
            if (res.has("type")) continue;
            String changeId = this.generateTheId(res, null);
            map.put(changeId, res);
            JSONArray arr = res.getJSONArray("patchSets");
            for (Object obj : arr) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject patch = (JSONObject)obj;
                String theId = this.generateTheId(res, patch);
                map.put(theId, patch);
            }
        }
        return map;
    }

    public String getGerritUrl(PatchsetCreated event) {
        if (event.getChange().getUrl() != null && event.getChange().getUrl().length() > 0) {
            return event.getChange().getUrl();
        }
        return PluginImpl.getInstance().getConfig().getGerritFrontEndUrlFor(event.getChange().getNumber(), event.getPatchSet().getNumber());
    }

    public List<ParameterValue> getParametersForPatchSet(JSONObject jsonChange, JSONObject jsonPatchSet) {
        LinkedList<ParameterValue> parameters = new LinkedList<ParameterValue>();
        Change change = new Change(jsonChange);
        PatchSet patchSet = new PatchSet(jsonPatchSet);
        PatchsetCreated event = new PatchsetCreated();
        event.setChange(change);
        event.setPatchset(patchSet);
        GerritTriggerParameters.setOrCreateParameters((GerritTriggeredEvent)event, parameters, false);
        return parameters;
    }

    public boolean hasUrl(ParameterValue parameterValue) {
        return GerritTriggerParameters.GERRIT_CHANGE_URL.name().equals(parameterValue.getName());
    }

    public String getGerritUrl(JSONObject change) {
        String url = change.optString("url", null);
        if (url != null && url.length() > 0) {
            return url;
        }
        if (change.optString("number", "").length() > 0) {
            return PluginImpl.getInstance().getConfig().getGerritFrontEndUrlFor(change.getString("number"), "1");
        }
        return "";
    }

    private ManualPatchsetCreated findAndCreatePatchSetEvent(String rowId, HashMap<String, JSONObject> indexed) {
        logger.trace("Searching for {}", (Object)rowId);
        String[] ids = rowId.split(ID_SEPARATOR);
        if (ids.length >= 3) {
            logger.debug("Correct nr of ids: {}", (Object)ids.length);
            JSONObject patch = indexed.get(rowId);
            if (patch != null) {
                logger.debug("Found the patch: {}", (Object)patch);
                String changeId = ids[0] + ID_SEPARATOR + ids[2];
                logger.debug("ChangeId calculated to: {}", (Object)changeId);
                JSONObject change = indexed.get(changeId);
                if (change != null) {
                    logger.debug("Found the change: {}", (Object)change);
                    return new ManualPatchsetCreated(change, patch, Hudson.getAuthentication().getName());
                }
                logger.trace("No change found with id {}", (Object)changeId);
                return null;
            }
            logger.trace("No patch found for id {}", (Object)rowId);
            return null;
        }
        logger.trace("Bad nr of ids.");
        return null;
    }

    private void triggerEvent(ManualPatchsetCreated event) {
        logger.trace("Going to trigger event: {}", (Object)event);
        PluginImpl.getInstance().triggerEvent((GerritEvent)event);
    }

    public static enum Approval {
        CODE_REVIEW("CRVW"),
        VERIFIED("VRIF");

        private String type;

        private Approval(String type) {
            this.type = type;
        }

        public HighLow getApprovals(JSONObject res) {
            logger.trace("Get Approval: {} {}", (Object)this.type, (Object)res);
            int highValue = Integer.MIN_VALUE;
            int lowValue = Integer.MAX_VALUE;
            if (res.has("currentPatchSet")) {
                logger.trace("Has currentPatchSet");
                JSONObject patchSet = res.getJSONObject("currentPatchSet");
                if (patchSet.has("approvals")) {
                    JSONArray approvals = patchSet.getJSONArray("approvals");
                    logger.trace("Approvals: ", (Object)approvals);
                    for (Object o : approvals) {
                        JSONObject ap = (JSONObject)o;
                        if (!this.type.equalsIgnoreCase(ap.optString("type"))) continue;
                        logger.trace("A {}", (Object)this.type);
                        try {
                            int approval = Integer.parseInt(ap.getString("value"));
                            highValue = Math.max(highValue, approval);
                            lowValue = Math.min(lowValue, approval);
                        }
                        catch (NumberFormatException nfe) {
                            logger.warn("Gerrit is bad at giving me Approval-numbers!", (Throwable)nfe);
                        }
                    }
                }
            }
            if (highValue == Integer.MIN_VALUE && lowValue == Integer.MAX_VALUE) {
                logger.debug("Returning all 0");
                return new HighLow(0, 0);
            }
            HighLow r = new HighLow(highValue, lowValue);
            logger.debug("Returning something {}", (Object)r);
            return r;
        }
    }

    public static class HighLow {
        private final int high;
        private final int low;

        public HighLow(int high, int low) {
            this.high = high;
            this.low = low;
        }

        public int getHigh() {
            return this.high;
        }

        public int getLow() {
            return this.low;
        }

        public String toString() {
            return "HighLow(" + this.high + "," + this.low + ")";
        }
    }
}

