/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RetriggerAction
implements Action {
    private TriggerContext context;

    public RetriggerAction(TriggerContext context) {
        this.context = context;
    }

    public RetriggerAction() {
    }

    public String getIconFileName() {
        if (!this.hasPermission() || this.isBuilding()) {
            return null;
        }
        return StringUtil.getPluginImageUrl("icon_retrigger24.png");
    }

    public String getDisplayName() {
        if (!this.hasPermission() || this.isBuilding()) {
            return null;
        }
        return Messages.Retrigger();
    }

    public String getUrlName() {
        if (!this.hasPermission() || this.isBuilding()) {
            return null;
        }
        return "gerrit-trigger-retrigger-this";
    }

    private boolean isBuilding() {
        if (this.context == null || this.context.getThisBuild() == null || this.context.getEvent() == null) {
            return false;
        }
        return this.context.getThisBuild().getBuild().isBuilding() || ToGerritRunListener.getInstance().isBuilding(this.context.getThisBuild().getProject(), this.context.getEvent());
    }

    private boolean hasPermission() {
        if (this.context == null || this.context.getThisBuild() == null || this.context.getThisBuild().getProject() == null) {
            return false;
        }
        return this.context.getThisBuild().getProject().hasPermission(AbstractProject.BUILD);
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.context == null || this.context.getThisBuild() == null) {
            return;
        }
        if (!this.hasPermission()) {
            return;
        }
        if (this.isBuilding()) {
            return;
        }
        TriggeredItemEntity entity = this.context.getThisBuild();
        GerritTrigger trigger = (GerritTrigger)entity.getProject().getTrigger(GerritTrigger.class);
        if (trigger == null) {
            return;
        }
        trigger.retriggerThisBuild(this.context);
        response.sendRedirect2(entity.getProject().getAbsoluteUrl());
    }
}

