/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritTriggerTimer {
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long DELAY_MILLISECONDS = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(GerritTriggerTimer.class);
    private static GerritTriggerTimer instance = null;
    private Timer timer = new Timer(true);

    private GerritTriggerTimer() {
    }

    public static GerritTriggerTimer getInstance() {
        if (instance == null) {
            instance = new GerritTriggerTimer();
        }
        return instance;
    }

    public void schedule(TimerTask timerTask) {
        long timerPeriod = 1000L * (long)PluginImpl.getInstance().getConfig().getDynamicConfigRefreshInterval();
        try {
            this.timer.schedule(timerTask, 5000L, timerPeriod);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Attempted use of negative delay", (Throwable)iae);
        }
        catch (IllegalStateException ise) {
            logger.error("Attempted re-use of TimerTask", (Throwable)ise);
        }
    }
}

