/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.Account;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.util.List;

public enum GerritTriggerParameters {
    GERRIT_CHANGE_SUBJECT,
    GERRIT_BRANCH,
    GERRIT_CHANGE_ID,
    GERRIT_CHANGE_NUMBER,
    GERRIT_CHANGE_URL,
    GERRIT_PATCHSET_NUMBER,
    GERRIT_PATCHSET_REVISION,
    GERRIT_PROJECT,
    GERRIT_REFSPEC,
    GERRIT_CHANGE_OWNER,
    GERRIT_CHANGE_OWNER_NAME,
    GERRIT_CHANGE_OWNER_EMAIL,
    GERRIT_PATCHSET_UPLOADER,
    GERRIT_PATCHSET_UPLOADER_NAME,
    GERRIT_PATCHSET_UPLOADER_EMAIL,
    GERRIT_EVENT_ACCOUNT,
    GERRIT_EVENT_ACCOUNT_NAME,
    GERRIT_EVENT_ACCOUNT_EMAIL,
    GERRIT_REFNAME,
    GERRIT_OLDREV,
    GERRIT_NEWREV,
    GERRIT_SUBMITTER,
    GERRIT_SUBMITTER_NAME,
    GERRIT_SUBMITTER_EMAIL,
    GERRIT_EVENT_HASH;


    public void setOrCreateStringParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        String stringValue;
        ParameterValue parameter = null;
        for (ParameterValue p : parameters) {
            if (!p.getName().toUpperCase().equals(this.name())) continue;
            parameter = p;
            break;
        }
        String description = null;
        if (parameter != null) {
            if (parameter instanceof StringParameterValue) {
                description = parameter.getDescription();
            }
            parameters.remove(parameter);
        }
        if ((stringValue = escapeQuotes ? StringUtil.escapeQuotes(value) : value) == null) {
            stringValue = "";
        }
        parameter = new StringParameterValue(this.name(), stringValue, description);
        parameters.add(parameter);
    }

    public static void setOrCreateParameters(GerritTriggeredEvent gerritEvent, List<ParameterValue> parameters, boolean escapeQuotes) {
        ChangeBasedEvent event;
        GERRIT_EVENT_HASH.setOrCreateStringParameterValue(parameters, String.valueOf(gerritEvent.hashCode()), escapeQuotes);
        if (gerritEvent instanceof ChangeBasedEvent) {
            event = (ChangeBasedEvent)gerritEvent;
            GERRIT_BRANCH.setOrCreateStringParameterValue(parameters, event.getChange().getBranch(), escapeQuotes);
            GERRIT_CHANGE_NUMBER.setOrCreateStringParameterValue(parameters, event.getChange().getNumber(), escapeQuotes);
            GERRIT_CHANGE_ID.setOrCreateStringParameterValue(parameters, event.getChange().getId(), escapeQuotes);
            GERRIT_PATCHSET_NUMBER.setOrCreateStringParameterValue(parameters, event.getPatchSet().getNumber(), escapeQuotes);
            GERRIT_PATCHSET_REVISION.setOrCreateStringParameterValue(parameters, event.getPatchSet().getRevision(), escapeQuotes);
            GERRIT_REFSPEC.setOrCreateStringParameterValue(parameters, StringUtil.makeRefSpec(event), escapeQuotes);
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getChange().getProject(), escapeQuotes);
            GERRIT_CHANGE_SUBJECT.setOrCreateStringParameterValue(parameters, event.getChange().getSubject(), escapeQuotes);
            String url = PluginImpl.getInstance().getConfig().getGerritFrontEndUrlFor(event.getChange().getNumber(), event.getPatchSet().getNumber());
            GERRIT_CHANGE_URL.setOrCreateStringParameterValue(parameters, url, escapeQuotes);
            GERRIT_CHANGE_OWNER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(event.getChange().getOwner()), escapeQuotes);
            GERRIT_CHANGE_OWNER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(event.getChange().getOwner()), escapeQuotes);
            GERRIT_CHANGE_OWNER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(event.getChange().getOwner()), escapeQuotes);
            Account uploader = GerritTriggerParameters.findUploader(event);
            GERRIT_PATCHSET_UPLOADER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(uploader), escapeQuotes);
            GERRIT_PATCHSET_UPLOADER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(uploader), escapeQuotes);
            GERRIT_PATCHSET_UPLOADER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(uploader), escapeQuotes);
        } else if (gerritEvent instanceof RefUpdated) {
            event = (RefUpdated)gerritEvent;
            GERRIT_REFNAME.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getRefName(), escapeQuotes);
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getProject(), escapeQuotes);
            GERRIT_OLDREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getOldRev(), escapeQuotes);
            GERRIT_NEWREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getNewRev(), escapeQuotes);
        }
        Account account = gerritEvent.getAccount();
        if (account != null) {
            GERRIT_EVENT_ACCOUNT.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(account), escapeQuotes);
            GERRIT_EVENT_ACCOUNT_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(account), escapeQuotes);
            GERRIT_EVENT_ACCOUNT_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(account), escapeQuotes);
        }
    }

    private static Account findUploader(ChangeBasedEvent event) {
        if (event.getPatchSet() != null && event.getPatchSet().getUploader() != null) {
            return event.getPatchSet().getUploader();
        }
        return event.getAccount();
    }

    private static String getName(Account account) {
        if (account == null) {
            return "";
        }
        return account.getName();
    }

    private static String getNameAndEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getNameAndEmail();
    }

    private static String getEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getEmail();
    }
}

