/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.DataBoundConstructor;

public class GerritTriggerBuildChooser
extends BuildChooser {
    private final String separator = "#";

    @DataBoundConstructor
    public GerritTriggerBuildChooser() {
    }

    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, IGitAPI git, TaskListener listener, BuildData data) throws GitException, IOException {
        try {
            ObjectId sha1 = git.revParse("FETCH_HEAD");
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(singleBranch, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            return Collections.emptyList();
        }
    }

    public Build prevBuildForChangelog(String singleBranch, BuildData data, IGitAPI git) {
        ObjectId sha1 = git.revParse("FETCH_HEAD");
        ObjectId parentSha1 = this.getFirstParent(ObjectId.toString((ObjectId)sha1), git);
        Revision parentRev = new Revision(parentSha1);
        parentRev.getBranches().add(new Branch(singleBranch, parentSha1));
        int prevBuildNum = 0;
        Result r = null;
        Build lastBuild = data.getLastBuildOfBranch(singleBranch);
        if (lastBuild != null) {
            prevBuildNum = lastBuild.getBuildNumber();
            r = lastBuild.getBuildResult();
        }
        Build newLastBuild = new Build(parentRev, prevBuildNum, r);
        return newLastBuild;
    }

    private ObjectId getFirstParent(String revName, IGitAPI git) throws GitException {
        String result = ((GitAPI)git).launchCommand(new String[]{"log", "-1", "--pretty=format:%P", revName});
        if (result.isEmpty() && (result = ((GitAPI)git).launchCommand(new String[]{"log", "-1", "--pretty=format:%H"})).isEmpty()) {
            throw new GitException("git log returned an empty string");
        }
        String parents = this.firstLine(result).trim();
        String firstParent = parents.split(" ")[0];
        return ObjectId.fromString((String)firstParent);
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", (Throwable)e);
        }
        return line;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getLegacyId() {
            return Messages.DisplayName();
        }
    }
}

