/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryHandler;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr.Approval;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeMerged;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.DraftPublished;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.BadgeAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritDynamicUrlProcessor;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritManualCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerParameters;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimerTask;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritUserCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.GerritTriggerInformationAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAllAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.SkipVote;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginCommentAddedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginDraftPublishedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginPatchsetCreatedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritTrigger
extends Trigger<AbstractProject>
implements GerritEventListener {
    private static final Logger logger = LoggerFactory.getLogger(GerritTrigger.class);
    private transient RunningJobs runningJobs = new RunningJobs();
    private transient AbstractProject myProject;
    private List<GerritProject> gerritProjects;
    private List<GerritProject> dynamicGerritProjects;
    private SkipVote skipVote;
    private Integer gerritBuildStartedVerifiedValue;
    private Integer gerritBuildStartedCodeReviewValue;
    private Integer gerritBuildSuccessfulVerifiedValue;
    private Integer gerritBuildSuccessfulCodeReviewValue;
    private Integer gerritBuildFailedVerifiedValue;
    private Integer gerritBuildFailedCodeReviewValue;
    private Integer gerritBuildUnstableVerifiedValue;
    private Integer gerritBuildUnstableCodeReviewValue;
    private Integer gerritBuildNotBuiltVerifiedValue;
    private Integer gerritBuildNotBuiltCodeReviewValue;
    private boolean silentMode;
    private boolean escapeQuotes;
    private String buildStartMessage;
    private String buildFailureMessage;
    private String buildSuccessfulMessage;
    private String buildUnstableMessage;
    private String buildNotBuiltMessage;
    private String buildUnsuccessfulFilepath;
    private String customUrl;
    private List<PluginGerritEvent> triggerOnEvents;
    private boolean dynamicTriggerConfiguration;
    private String triggerConfigURL;
    private GerritTriggerTimerTask gerritTriggerTimerTask;
    private GerritTriggerInformationAction triggerInformationAction;

    @DataBoundConstructor
    public GerritTrigger(List<GerritProject> gerritProjects, SkipVote skipVote, Integer gerritBuildStartedVerifiedValue, Integer gerritBuildStartedCodeReviewValue, Integer gerritBuildSuccessfulVerifiedValue, Integer gerritBuildSuccessfulCodeReviewValue, Integer gerritBuildFailedVerifiedValue, Integer gerritBuildFailedCodeReviewValue, Integer gerritBuildUnstableVerifiedValue, Integer gerritBuildUnstableCodeReviewValue, Integer gerritBuildNotBuiltVerifiedValue, Integer gerritBuildNotBuiltCodeReviewValue, boolean silentMode, boolean escapeQuotes, String buildStartMessage, String buildSuccessfulMessage, String buildUnstableMessage, String buildFailureMessage, String buildNotBuiltMessage, String buildUnsuccessfulFilepath, String customUrl, List<PluginGerritEvent> triggerOnEvents, boolean dynamicTriggerConfiguration, String triggerConfigURL) {
        this.gerritProjects = gerritProjects;
        this.skipVote = skipVote;
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
        this.silentMode = silentMode;
        this.escapeQuotes = escapeQuotes;
        this.buildStartMessage = buildStartMessage;
        this.buildSuccessfulMessage = buildSuccessfulMessage;
        this.buildUnstableMessage = buildUnstableMessage;
        this.buildFailureMessage = buildFailureMessage;
        this.buildNotBuiltMessage = buildNotBuiltMessage;
        this.buildUnsuccessfulFilepath = buildUnsuccessfulFilepath;
        this.customUrl = customUrl;
        this.triggerOnEvents = triggerOnEvents;
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
        this.triggerConfigURL = triggerConfigURL;
        this.gerritTriggerTimerTask = null;
        this.triggerInformationAction = new GerritTriggerInformationAction();
    }

    public Object readResolve() throws ObjectStreamException {
        this.initializeTriggerOnEvents();
        return super.readResolve();
    }

    public static GerritTrigger getTrigger(AbstractProject project) {
        return (GerritTrigger)project.getTrigger(GerritTrigger.class);
    }

    public void cancelTimer() {
        if (this.gerritTriggerTimerTask != null) {
            logger.trace("GerritTrigger.cancelTimer(): {0}", (Object)this.myProject.getName());
            this.gerritTriggerTimerTask.cancel();
            this.gerritTriggerTimerTask = null;
        }
    }

    public void start(AbstractProject project, boolean newInstance) {
        logger.debug("Start project: {}", (Object)project);
        super.start((Item)project, newInstance);
        this.initializeTriggerOnEvents();
        this.myProject = project;
        try {
            if (PluginImpl.getInstance() != null) {
                PluginImpl.getInstance().addListener(this);
            } else {
                logger.warn("The plugin instance could not be found! Project {} will not be triggered!", (Object)project.getFullDisplayName());
            }
        }
        catch (IllegalStateException e) {
            logger.error("I am too early!", (Throwable)e);
        }
        if (this.dynamicTriggerConfiguration) {
            this.gerritTriggerTimerTask = new GerritTriggerTimerTask(this);
        }
    }

    public void stop() {
        logger.debug("Stop");
        super.stop();
        try {
            if (PluginImpl.getInstance() != null) {
                PluginImpl.getInstance().removeListener(this);
            }
        }
        catch (IllegalStateException e) {
            logger.error("I am too late!", (Throwable)e);
        }
        this.cancelTimer();
    }

    public void gerritEvent(GerritEvent event) {
    }

    public void gerritEvent(PatchsetCreated event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (this.isInteresting((GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, (GerritTriggeredEvent)event);
            } else {
                event.fireProjectTriggered(this.myProject);
            }
            GerritCause cause = event instanceof ManualPatchsetCreated ? new GerritManualCause((ManualPatchsetCreated)event, this.silentMode) : new GerritCause((GerritTriggeredEvent)event, this.silentMode);
            this.schedule(cause, (GerritTriggeredEvent)event);
        }
    }

    public void gerritEvent(DraftPublished event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (this.isInteresting((GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, (GerritTriggeredEvent)event);
            } else {
                event.fireProjectTriggered(this.myProject);
            }
            this.schedule(new GerritCause((GerritTriggeredEvent)event, this.silentMode), (GerritTriggeredEvent)event);
        }
    }

    private boolean shouldTriggerOnEventType(GerritTriggeredEvent event) {
        if (this.triggerOnEvents == null || this.triggerOnEvents.isEmpty()) {
            return false;
        }
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (!e.getCorrespondingEventClass().isInstance(event)) continue;
            return true;
        }
        return false;
    }

    protected void schedule(GerritCause cause, GerritTriggeredEvent event) {
        this.schedule(cause, event, this.myProject);
    }

    protected void schedule(GerritCause cause, GerritTriggeredEvent event, AbstractProject project) {
        BadgeAction badgeAction = new BadgeAction(event);
        int projectbuildDelay = this.getBuildScheduleDelay();
        if (cause instanceof GerritUserCause) {
            projectbuildDelay = 0;
        } else if (project.getHasCustomQuietPeriod() && project.getQuietPeriod() > projectbuildDelay) {
            projectbuildDelay = project.getQuietPeriod();
        }
        ParametersAction parameters = this.createParameters(event, project);
        Future build = project.scheduleBuild2(projectbuildDelay, (Cause)cause, new Action[]{badgeAction, new RetriggerAction(cause.getContext()), new RetriggerAllAction(cause.getContext()), parameters});
        if (event instanceof ChangeBasedEvent) {
            ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)event;
            if (PluginImpl.getInstance().getConfig().isGerritBuildCurrentPatchesOnly()) {
                this.getRunningJobs().scheduled(changeBasedEvent, parameters, project.getName());
            }
            logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), build != null, changeBasedEvent.getChange().getNumber() + "/" + changeBasedEvent.getPatchSet().getNumber()});
        } else if (event instanceof RefUpdated) {
            RefUpdated refUpdated = (RefUpdated)event;
            logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), build != null, refUpdated.getRefUpdate().getRefName() + " " + refUpdated.getRefUpdate().getNewRev()});
        }
    }

    private synchronized RunningJobs getRunningJobs() {
        if (this.runningJobs == null) {
            this.runningJobs = new RunningJobs();
        }
        return this.runningJobs;
    }

    public void notifyBuildEnded(GerritTriggeredEvent event) {
        if (event instanceof ChangeBasedEvent && PluginImpl.getInstance().getConfig().isGerritBuildCurrentPatchesOnly()) {
            this.getRunningJobs().remove((ChangeBasedEvent)event);
        }
    }

    public int getBuildScheduleDelay() {
        if (PluginImpl.getInstance() == null || PluginImpl.getInstance().getConfig() == null) {
            return 3;
        }
        int buildScheduleDelay = PluginImpl.getInstance().getConfig().getBuildScheduleDelay();
        if (buildScheduleDelay < 3) {
            return 3;
        }
        return buildScheduleDelay;
    }

    protected ParametersAction createParameters(GerritTriggeredEvent event, AbstractProject project) {
        List<ParameterValue> parameters = this.getDefaultParametersValues(project);
        GerritTriggerParameters.setOrCreateParameters(event, parameters, this.isEscapeQuotes());
        return new ParametersAction(parameters);
    }

    private List<ParameterValue> getDefaultParametersValues(AbstractProject project) {
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (paramDefProp == null) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public void retriggerThisBuild(TriggerContext context) {
        if (context.getThisBuild().getProject().isBuildable() && !ToGerritRunListener.getInstance().isBuilding(context.getThisBuild().getProject(), context.getEvent())) {
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onRetriggered(context.getThisBuild().getProject(), context.getEvent(), context.getOtherBuilds());
            }
            GerritUserCause cause = new GerritUserCause(context.getEvent(), this.silentMode);
            this.schedule(cause, context.getEvent(), context.getThisBuild().getProject());
        }
    }

    public void retriggerAllBuilds(TriggerContext context) {
        if (!ToGerritRunListener.getInstance().isBuilding(context.getEvent())) {
            this.retrigger(context.getThisBuild().getProject(), context.getEvent());
            for (AbstractBuild build : context.getOtherBuilds()) {
                GerritTrigger trigger = (GerritTrigger)build.getProject().getTrigger(GerritTrigger.class);
                if (trigger == null) continue;
                trigger.retrigger(build.getProject(), context.getEvent());
            }
        }
    }

    private void retrigger(AbstractProject project, GerritTriggeredEvent event) {
        if (project.isBuildable()) {
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onRetriggered(project, event, null);
            }
            GerritUserCause cause = new GerritUserCause(event, this.silentMode);
            this.schedule(cause, event, project);
        }
    }

    public int hashCode() {
        if (this.myProject == null) {
            return super.hashCode();
        }
        return this.myProject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GerritTrigger) {
            GerritTrigger that = (GerritTrigger)((Object)obj);
            return this.myProject == that.myProject;
        }
        return false;
    }

    private boolean isInteresting(GerritTriggeredEvent event) {
        if (!this.shouldTriggerOnEventType(event)) {
            return false;
        }
        LinkedList<GerritProject> allGerritProjects = new LinkedList<GerritProject>();
        if (this.gerritProjects != null) {
            allGerritProjects.addAll(this.gerritProjects);
        }
        if (this.dynamicGerritProjects != null) {
            allGerritProjects.addAll(this.dynamicGerritProjects);
        }
        logger.trace("entering isInteresting projects configured: {} the event: {}", (Object)allGerritProjects.size(), (Object)event);
        for (GerritProject p : allGerritProjects) {
            try {
                RefUpdated refUpdated;
                if (event instanceof ChangeBasedEvent) {
                    ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)event;
                    if (!p.isInteresting(changeBasedEvent.getChange().getProject(), changeBasedEvent.getChange().getBranch())) continue;
                    if (this.isFileTriggerEnabled() && p.getFilePaths() != null && p.getFilePaths().size() > 0) {
                        if (!p.isInteresting(changeBasedEvent.getChange().getProject(), changeBasedEvent.getChange().getBranch(), changeBasedEvent.getFiles(new GerritQueryHandler((GerritConnectionConfig)PluginImpl.getInstance().getConfig())))) continue;
                        logger.trace("According to {} the event is interesting.", (Object)p);
                        return true;
                    }
                    logger.trace("According to {} the event is interesting.", (Object)p);
                    return true;
                }
                if (!(event instanceof RefUpdated) || !p.isInteresting((refUpdated = (RefUpdated)event).getRefUpdate().getProject(), refUpdated.getRefUpdate().getRefName())) continue;
                logger.trace("According to {} the event is interesting.", (Object)p);
                return true;
            }
            catch (PatternSyntaxException pse) {
                logger.error(MessageFormat.format("Exception caught for project {0} and pattern {1}, message: {2}", this.myProject.getName(), p.getPattern(), pse.getMessage()));
            }
        }
        logger.trace("Nothing interesting here, move along folks!");
        return false;
    }

    public void gerritEvent(ChangeAbandoned event) {
    }

    public void gerritEvent(ChangeMerged event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (this.isInteresting((GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, (GerritTriggeredEvent)event);
            }
            GerritCause cause = new GerritCause((GerritTriggeredEvent)event, this.silentMode);
            this.schedule(cause, (GerritTriggeredEvent)event);
        }
    }

    private boolean matchesApproval(CommentAdded event) {
        PluginCommentAddedEvent commentAdded = null;
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (!(e instanceof PluginCommentAddedEvent)) continue;
            commentAdded = (PluginCommentAddedEvent)e;
            for (Approval approval : event.getApprovals()) {
                if (!approval.getType().equals(commentAdded.getVerdictCategory()) || !approval.getValue().equals(commentAdded.getCommentAddedTriggerApprovalValue()) && !("+" + approval.getValue()).equals(commentAdded.getCommentAddedTriggerApprovalValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void gerritEvent(CommentAdded event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (ToGerritRunListener.getInstance().isBuilding(this.myProject, (GerritTriggeredEvent)event)) {
            logger.trace("Already building.");
            return;
        }
        if (this.isInteresting((GerritTriggeredEvent)event) && this.matchesApproval(event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, (GerritTriggeredEvent)event);
            }
            GerritCause cause = new GerritCause((GerritTriggeredEvent)event, this.silentMode);
            this.schedule(cause, (GerritTriggeredEvent)event);
        }
    }

    public void gerritEvent(RefUpdated event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (this.isInteresting((GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, (GerritTriggeredEvent)event);
            }
            GerritCause cause = new GerritCause((GerritTriggeredEvent)event, this.silentMode);
            this.schedule(cause, (GerritTriggeredEvent)event);
        }
    }

    public List<GerritProject> getGerritProjects() {
        return this.gerritProjects;
    }

    public List<GerritProject> getDynamicGerritProjects() {
        return this.dynamicGerritProjects;
    }

    public void setGerritProjects(List<GerritProject> gerritProjects) {
        this.gerritProjects = gerritProjects;
    }

    public Integer getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    public void setGerritBuildFailedCodeReviewValue(Integer gerritBuildFailedCodeReviewValue) {
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
    }

    public Integer getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    public void setGerritBuildFailedVerifiedValue(Integer gerritBuildFailedVerifiedValue) {
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
    }

    public Integer getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    public void setGerritBuildStartedCodeReviewValue(Integer gerritBuildStartedCodeReviewValue) {
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
    }

    public Integer getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    public void setGerritBuildStartedVerifiedValue(Integer gerritBuildStartedVerifiedValue) {
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
    }

    public Integer getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    public void setGerritBuildSuccessfulCodeReviewValue(Integer gerritBuildSuccessfulCodeReviewValue) {
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
    }

    public Integer getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    public void setGerritBuildSuccessfulVerifiedValue(Integer gerritBuildSuccessfulVerifiedValue) {
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
    }

    public Integer getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    public void setGerritBuildUnstableCodeReviewValue(Integer gerritBuildUnstableCodeReviewValue) {
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
    }

    public Integer getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    public void setGerritBuildUnstableVerifiedValue(Integer gerritBuildUnstableVerifiedValue) {
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
    }

    public Integer getGerritBuildNotBuiltCodeReviewValue() {
        return this.gerritBuildNotBuiltCodeReviewValue;
    }

    public void setGerritBuildNotBuiltCodeReviewValue(Integer gerritBuildNotBuiltCodeReviewValue) {
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
    }

    public Integer getGerritBuildNotBuiltVerifiedValue() {
        return this.gerritBuildNotBuiltVerifiedValue;
    }

    public void setGerritBuildNotBuiltVerifiedValue(Integer gerritBuildNotBuiltVerifiedValue) {
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
    }

    public void setBuildUnsuccessfulFilepath(String path) {
        this.buildUnsuccessfulFilepath = path;
    }

    public List<PluginGerritEvent> getTriggerOnEvents() {
        this.initializeTriggerOnEvents();
        return this.triggerOnEvents;
    }

    private void initializeTriggerOnEvents() {
        if (this.triggerOnEvents == null) {
            this.triggerOnEvents = new LinkedList<PluginGerritEvent>();
        }
        if (this.triggerOnEvents.isEmpty()) {
            this.triggerOnEvents.add(new PluginPatchsetCreatedEvent());
            if (this.isTriggerOnDraftPublishedEnabled()) {
                this.triggerOnEvents.add(new PluginDraftPublishedEvent());
            }
        }
    }

    public boolean isDynamicTriggerConfiguration() {
        return this.dynamicTriggerConfiguration;
    }

    public void setDynamicTriggerConfiguration(boolean dynamicTriggerConfiguration) {
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
    }

    public String getTriggerConfigURL() {
        return this.triggerConfigURL;
    }

    public void setTriggerConfigURL(String triggerConfigURL) {
        this.triggerConfigURL = triggerConfigURL;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public boolean isEscapeQuotes() {
        return this.escapeQuotes;
    }

    public void setEscapeQuotes(boolean escapeQuotes) {
        this.escapeQuotes = escapeQuotes;
    }

    public String getBuildStartMessage() {
        return this.buildStartMessage;
    }

    public String getBuildSuccessfulMessage() {
        return this.buildSuccessfulMessage;
    }

    public String getBuildUnstableMessage() {
        return this.buildUnstableMessage;
    }

    public String getBuildFailureMessage() {
        return this.buildFailureMessage;
    }

    public String getBuildNotBuiltMessage() {
        return this.buildNotBuiltMessage;
    }

    public String getBuildUnsuccessfulFilepath() {
        return this.buildUnsuccessfulFilepath;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public void setCustomUrl(String customUrl) {
        this.customUrl = customUrl;
    }

    public boolean isFileTriggerEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.fileTrigger);
    }

    public void updateTriggerConfigURL() {
        if (this.triggerInformationAction == null) {
            this.triggerInformationAction = new GerritTriggerInformationAction();
        }
        this.triggerInformationAction.setErrorMessage("");
        try {
            List<GerritProject> fetchedProjects = GerritDynamicUrlProcessor.fetch(this.triggerConfigURL);
            this.dynamicGerritProjects = fetchedProjects;
        }
        catch (ParseException pe) {
            String logErrorMessage = MessageFormat.format("ParseException for project: {0} and URL: {1} Message: {2}", this.myProject.getName(), this.triggerConfigURL, pe.getMessage());
            logger.error(logErrorMessage, (Throwable)pe);
            String triggerInformationMessage = MessageFormat.format("ParseException when fetching dynamic trigger url: {0}", pe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (MalformedURLException mue) {
            String logErrorMessage = MessageFormat.format("MalformedURLException for project: {0} and URL: {1} Message: {2}", this.myProject.getName(), this.triggerConfigURL, mue.getMessage());
            logger.error(logErrorMessage, (Throwable)mue);
            String triggerInformationMessage = MessageFormat.format("MalformedURLException when fetching dynamic trigger url: {0}", mue.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (SocketTimeoutException ste) {
            String logErrorMessage = MessageFormat.format("SocketTimeoutException for project: {0} and URL: {1} Message: {2}", this.myProject.getName(), this.triggerConfigURL, ste.getMessage());
            logger.error(logErrorMessage, (Throwable)ste);
            String triggerInformationMessage = MessageFormat.format("SocketTimeoutException when fetching dynamic trigger url: {0}", ste.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (IOException ioe) {
            String logErrorMessage = MessageFormat.format("IOException for project: {0} and URL: {1} Message: {2}", this.myProject.getName(), this.triggerConfigURL, ioe.getMessage());
            logger.error(logErrorMessage, (Throwable)ioe);
            String triggerInformationMessage = MessageFormat.format("IOException when fetching dynamic trigger url: {0}", ioe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
    }

    public boolean isTriggerOnDraftPublishedEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.triggerOnDraftPublished);
    }

    public List<Action> getProjectActions() {
        LinkedList<Action> list = new LinkedList<Action>();
        list.add(this.triggerInformationAction);
        return list;
    }

    public SkipVote getSkipVote() {
        return this.skipVote;
    }

    public class RunningJobs {
        private final HashMap<GerritTriggeredEvent, ParametersAction> runningJobs = new HashMap();

        public synchronized void scheduled(ChangeBasedEvent event, ParametersAction parameters, String projectName) {
            if (!PluginImpl.getInstance().getConfig().isGerritBuildCurrentPatchesOnly()) {
                return;
            }
            Iterator<Map.Entry<GerritTriggeredEvent, ParametersAction>> it = this.runningJobs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<GerritTriggeredEvent, ParametersAction> pairs = it.next();
                if (!(pairs.getKey() instanceof ChangeBasedEvent) || !((ChangeBasedEvent)pairs.getKey()).getChange().equals((Object)event.getChange())) continue;
                logger.debug("Cancelling build for " + pairs.getKey());
                try {
                    this.cancelJob(pairs.getValue());
                }
                catch (Exception e) {
                    logger.error("Error canceling job", (Throwable)e);
                }
                it.remove();
            }
            this.runningJobs.put((GerritTriggeredEvent)event, parameters);
        }

        private void cancelJob(ParametersAction parameters) {
            List itemsInQueue = Queue.getInstance().getItems((Queue.Task)GerritTrigger.this.myProject);
            for (Queue.Item item : itemsInQueue) {
                List params = item.getActions(ParametersAction.class);
                for (ParametersAction param : params) {
                    if (!param.equals(parameters)) continue;
                    Queue.getInstance().cancel(item);
                }
            }
            for (Computer c : Hudson.getInstance().getComputers()) {
                for (Executor e : c.getExecutors()) {
                    if (!(e.getCurrentExecutable() instanceof Actionable)) continue;
                    Actionable a = (Actionable)e.getCurrentExecutable();
                    List params = a.getActions(ParametersAction.class);
                    for (ParametersAction param : params) {
                        if (!param.equals(parameters)) continue;
                        e.interrupt();
                    }
                }
            }
        }

        public synchronized ParametersAction remove(ChangeBasedEvent event) {
            logger.debug("Removing future job " + event.getPatchSet().getNumber());
            return this.runningJobs.remove(event);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public FormValidation doEmptyOrIntegerCheck(@QueryParameter(value="value") String value) {
            if (value == null || value.length() <= 0) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)hudson.model.Messages.Hudson_NotANumber());
            }
        }

        public FormValidation doUrlCheck(@QueryParameter(value="value") String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)Messages.EmptyError());
            }
            try {
                URL url = new URL(value);
                url.toURI();
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.BadUrlError());
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)Messages.BadUrlError());
            }
        }

        public DescriptorImpl() {
            super(GerritTrigger.class);
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.TriggerDisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gerrit-trigger/help-whatIsGerritTrigger.html";
        }

        public ListBoxModel doFillVerdictCategoryItems() {
            ListBoxModel m = new ListBoxModel();
            List<VerdictCategory> list = PluginImpl.getInstance().getConfig().getCategories();
            if (list != null && !list.isEmpty()) {
                for (VerdictCategory v : list) {
                    m.add(v.getVerdictDescription(), v.getVerdictValue());
                }
            }
            return m;
        }

        public CompareType[] getCompareTypes() {
            return CompareType.values();
        }

        public boolean isFileTriggerEnabled() {
            return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.fileTrigger);
        }

        public List<PluginGerritEvent.PluginGerritEventDescriptor> getGerritEventDescriptors() {
            ExtensionList extensionList = Hudson.getInstance().getExtensionList(PluginGerritEvent.PluginGerritEventDescriptor.class);
            return extensionList;
        }
    }
}

