/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Branch;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.FilePath;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritDynamicUrlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GerritDynamicUrlProcessor.class);
    private static final String SHORTNAME_PROJECT = "p";
    private static final String SHORTNAME_BRANCH = "b";
    private static final String SHORTNAME_FILE = "f";
    private static final int SOCKET_READ_TIMEOUT = 10000;

    private GerritDynamicUrlProcessor() {
    }

    public static List<GerritProject> fetch(String gerritTriggerConfigUrl) throws IOException, ParseException {
        if (gerritTriggerConfigUrl == null) {
            throw new MalformedURLException("The gerritTriggerConfigUrl is null");
        }
        if (gerritTriggerConfigUrl.isEmpty()) {
            throw new MalformedURLException("The gerritTriggerConfigUrl is empty");
        }
        URL url = new URL(gerritTriggerConfigUrl);
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(10000);
        connection.setDoInput(true);
        InputStream instream = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
        String projectBranchFile = "^(p|b|f)";
        String operators = "(";
        boolean firstoperator = true;
        for (CompareType type : CompareType.values()) {
            if (!firstoperator) {
                operators = operators + "|";
            }
            operators = operators + type.getOperator();
            firstoperator = false;
        }
        operators = operators + ")";
        Pattern linePattern = Pattern.compile(projectBranchFile + "\\s*" + operators + "\\s*(.+)$");
        ArrayList<GerritProject> dynamicGerritProjects = new ArrayList<GerritProject>();
        ArrayList<Branch> branches = null;
        ArrayList<FilePath> filePaths = null;
        GerritProject dynamicGerritProject = null;
        String line = "";
        int lineNr = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNr;
            int commentPos = line.indexOf(35);
            if (commentPos > -1) {
                line = line.substring(0, commentPos);
            }
            if ((commentPos = line.indexOf(59)) > -1) {
                line = line.substring(0, commentPos);
            }
            if ((line = line.trim()).equals("")) continue;
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.matches()) {
                throw new ParseException("Line " + lineNr + ": cannot parse '" + line + "'", lineNr);
            }
            String item = matcher.group(1);
            String oper = matcher.group(2);
            String text = matcher.group(3);
            if (item == null || oper == null || text == null) {
                throw new ParseException("Line " + lineNr + ": cannot parse '" + line + "'", lineNr);
            }
            char operChar = oper.charAt(0);
            CompareType type = CompareType.findByOperator(operChar);
            logger.trace("==> item:({0}) oper:({1}) text:({2})", new Object[]{item, oper, text});
            if (SHORTNAME_PROJECT.equals(item)) {
                if (dynamicGerritProject != null) {
                    dynamicGerritProjects.add(dynamicGerritProject);
                }
                branches = new ArrayList<Branch>();
                filePaths = new ArrayList<FilePath>();
                dynamicGerritProject = new GerritProject(type, text, branches, filePaths);
                continue;
            }
            if (SHORTNAME_BRANCH.equals(item)) {
                if (branches == null) {
                    throw new ParseException("Line " + lineNr + ": attempt to use 'Branch' before 'Project'", lineNr);
                }
                Branch branch = new Branch(type, text);
                branches.add(branch);
                dynamicGerritProject.setBranches(branches);
                continue;
            }
            if (filePaths == null) {
                throw new ParseException("Line " + lineNr + ": attempt to use 'FilePath' before 'Project'", lineNr);
            }
            FilePath filePath = new FilePath(type, text);
            filePaths.add(filePath);
            dynamicGerritProject.setFilePaths(filePaths);
        }
        if (dynamicGerritProject != null) {
            dynamicGerritProjects.add(dynamicGerritProject);
        }
        return dynamicGerritProjects;
    }
}

