/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import hudson.triggers.SCMTrigger;

public class GerritCause
extends SCMTrigger.SCMTriggerCause {
    private GerritTriggeredEvent tEvent;
    private boolean silentMode;
    private TriggerContext context;
    @Deprecated
    private transient PatchsetCreated event;

    public GerritCause(GerritTriggeredEvent event, boolean silentMode) {
        super("");
        this.tEvent = event;
        this.silentMode = silentMode;
        this.context = new TriggerContext(event);
    }

    public GerritCause(GerritTriggeredEvent event, boolean silentMode, TriggerContext context) {
        super("");
        this.tEvent = event;
        this.silentMode = silentMode;
        this.context = context;
    }

    public GerritCause() {
        super("");
    }

    public GerritTriggeredEvent getEvent() {
        return this.tEvent;
    }

    public void setEvent(GerritTriggeredEvent event) {
        this.tEvent = event;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public TriggerContext getContext() {
        return this.context;
    }

    public void setContext(TriggerContext context) {
        this.context = context;
    }

    protected String getShortGerritDescription() {
        return Messages.TriggeredShortDescription(this.getUrl());
    }

    protected String getShortGerritDescriptionSilentMode() {
        return Messages.TriggeredShortDescriptionInSilentMode(this.getUrl());
    }

    public String getShortDescription() {
        if (this.isSilentMode()) {
            return this.getShortGerritDescriptionSilentMode();
        }
        return this.getShortGerritDescription();
    }

    public String getUrl() {
        if (this.tEvent instanceof ChangeBasedEvent) {
            ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)this.tEvent;
            return PluginImpl.getInstance().getConfig().getGerritFrontEndUrlFor(changeBasedEvent.getChange().getNumber(), changeBasedEvent.getPatchSet().getNumber());
        }
        return PluginImpl.getInstance().getConfig().getGerritFrontEndUrl();
    }

    public String toString() {
        return "GerritCause: " + this.tEvent + " silent: " + this.silentMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GerritCause that = (GerritCause)((Object)o);
        if (this.silentMode != that.silentMode) {
            return false;
        }
        return this.tEvent.equals(that.tEvent);
    }

    public int hashCode() {
        int result = this.tEvent.hashCode();
        result = 31 * result + (this.silentMode ? 1 : 0);
        return result;
    }

    Object readResolve() {
        if (this.event != null) {
            this.tEvent = this.event;
            this.event = null;
        }
        return this;
    }
}

