/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionNumber;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritAdministrativeMonitor
extends AdministrativeMonitor
implements ConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(GerritAdministrativeMonitor.class);
    private boolean connected = false;
    private boolean gerritSnapshotVersion;
    private List<GerritVersionChecker.Feature> disabledFeatures;

    public GerritAdministrativeMonitor() {
        this.addThisAsConnectionListener();
    }

    protected void addThisAsConnectionListener() {
        if (PluginImpl.getInstance() != null) {
            this.connected = PluginImpl.getInstance().addListener(this);
            this.checkGerritVersionFeatures();
        } else {
            Runnable runner = new Runnable(){
                private static final int SLEEP_INTERVAL = 500;

                @Override
                public void run() {
                    while (PluginImpl.getInstance() == null) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            logger.debug("Got interrupted while sleeping...", (Throwable)ex);
                        }
                    }
                    PluginImpl plugin = PluginImpl.getInstance();
                    if (plugin != null) {
                        GerritAdministrativeMonitor.this.connected = plugin.addListener(GerritAdministrativeMonitor.this);
                        GerritAdministrativeMonitor.this.checkGerritVersionFeatures();
                    } else {
                        logger.error("Unable to register GerritAdministrativeMonitor");
                    }
                }
            };
            Thread thread = new Thread(runner);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public boolean isSendQueueWarning() {
        return this.getSendQueueSize() >= 20;
    }

    public int getSendQueueSize() {
        return GerritSendCommandQueue.getQueueSize();
    }

    public boolean isConnectionWarning() {
        return !this.connected && PluginImpl.getInstance().getConfig().hasDefaultValues();
    }

    public boolean isConnectionError() {
        return !this.connected && !PluginImpl.getInstance().getConfig().hasDefaultValues();
    }

    public boolean isActivated() {
        return this.isConnectionWarning() || this.isConnectionError() || this.isSendQueueWarning() || this.isGerritSnapshotVersion() || this.hasDisabledFeatures();
    }

    public boolean isGerritSnapshotVersion() {
        return this.gerritSnapshotVersion;
    }

    public List<GerritVersionChecker.Feature> getDisabledFeatures() {
        return this.disabledFeatures;
    }

    public boolean hasDisabledFeatures() {
        return this.disabledFeatures != null && !this.disabledFeatures.isEmpty();
    }

    public void connectionEstablished() {
        this.connected = true;
        this.checkGerritVersionFeatures();
    }

    public void connectionDown() {
        this.connected = false;
        this.checkGerritVersionFeatures();
    }

    private void checkGerritVersionFeatures() {
        try {
            if (this.connected) {
                GerritVersionNumber version = GerritVersionChecker.createVersionNumber(PluginImpl.getInstance().getGerritVersion());
                LinkedList<GerritVersionChecker.Feature> list = new LinkedList<GerritVersionChecker.Feature>();
                for (GerritVersionChecker.Feature f : GerritVersionChecker.Feature.values()) {
                    if (GerritVersionChecker.isCorrectVersion(version, f)) continue;
                    list.add(f);
                }
                this.disabledFeatures = list;
                this.gerritSnapshotVersion = version.isSnapshot();
            } else {
                this.disabledFeatures = null;
                this.gerritSnapshotVersion = false;
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to calculate version info! ", (Throwable)ex);
        }
    }
}

