/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.Logic;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildMemory {
    private TreeMap<GerritTriggeredEvent, MemoryImprint> memory = new TreeMap(new GerritTriggeredEventComparator());
    private static final Logger logger = LoggerFactory.getLogger(BuildMemory.class);

    public synchronized MemoryImprint getMemoryImprint(GerritTriggeredEvent event) {
        return this.memory.get(event);
    }

    public synchronized boolean isAllBuildsCompleted(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.isAllBuildsCompleted();
        }
        return false;
    }

    public synchronized BuildsStartedStats getBuildsStartedStats(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.getBuildsStartedStats();
        }
        return null;
    }

    public synchronized String getStatusReport(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.getStatusReport();
        }
        return null;
    }

    public synchronized boolean isAllBuildsStarted(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.isAllBuildsSet();
        }
        return false;
    }

    public synchronized void completed(GerritTriggeredEvent event, AbstractBuild build) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
        }
        pb.set(build.getProject(), build, true);
    }

    public synchronized void started(GerritTriggeredEvent event, AbstractBuild build) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            logger.warn("Build started without being registered first.");
            this.memory.put(event, pb);
        }
        pb.set(build.getProject(), build);
    }

    public synchronized void triggered(GerritTriggeredEvent event, AbstractProject project) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
        }
        pb.set(project);
    }

    public synchronized void retriggered(GerritTriggeredEvent event, AbstractProject project, List<AbstractBuild> otherBuilds) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
            if (otherBuilds != null) {
                for (AbstractBuild build : otherBuilds) {
                    pb.set(build.getProject(), build, !build.isBuilding());
                }
            }
        }
        pb.reset(project);
    }

    public synchronized void forget(GerritTriggeredEvent event) {
        this.memory.remove(event);
    }

    public synchronized void updateTriggerContext(GerritCause cause, AbstractBuild r) {
        MemoryImprint imprint = this.getMemoryImprint(cause.getEvent());
        TriggerContext context = cause.getContext();
        context.setThisBuild(r);
        for (MemoryImprint.Entry entry : imprint.getEntries()) {
            if (entry.getBuild() != null && !entry.getBuild().equals(r)) {
                context.addOtherBuild(entry.getBuild());
                this.updateTriggerContext(entry, imprint);
                continue;
            }
            if (entry.getBuild() != null || entry.getProject().equals(r.getProject())) continue;
            context.addOtherProject(entry.getProject());
        }
        if (!r.hasntStartedYet() && !r.isBuilding()) {
            try {
                r.save();
            }
            catch (IOException ex) {
                logger.error("Could not save build state for build " + r, (Throwable)ex);
            }
        }
    }

    private synchronized void updateTriggerContext(MemoryImprint.Entry entryToUpdate, MemoryImprint imprint) {
        GerritCause cause;
        if (entryToUpdate.getBuild() != null && (cause = (GerritCause)entryToUpdate.getBuild().getCause(GerritCause.class)) != null) {
            TriggerContext context = cause.getContext();
            for (MemoryImprint.Entry ent : imprint.getEntries()) {
                if (ent.getBuild() != null && !ent.getBuild().equals(entryToUpdate.getBuild())) {
                    context.addOtherBuild(ent.getBuild());
                    continue;
                }
                if (ent.getBuild() != null || ent.getProject().equals(entryToUpdate.getProject())) continue;
                context.addOtherProject(ent.getProject());
            }
            if (!entryToUpdate.getBuild().hasntStartedYet() && !entryToUpdate.getBuild().isBuilding()) {
                try {
                    entryToUpdate.getBuild().save();
                }
                catch (IOException ex) {
                    logger.error("Could not save state for build " + entryToUpdate.getBuild(), (Throwable)ex);
                }
            }
        }
    }

    public synchronized boolean isBuilding(GerritTriggeredEvent event, AbstractProject project) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            return false;
        }
        for (MemoryImprint.Entry entry : pb.getEntries()) {
            if (!entry.getProject().equals(project)) continue;
            if (entry.getBuild() != null) {
                return !entry.isBuildCompleted();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBuilding(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        return pb != null;
    }

    public synchronized List<AbstractBuild> getBuilds(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            LinkedList<AbstractBuild> list = new LinkedList<AbstractBuild>();
            for (MemoryImprint.Entry entry : pb.getEntries()) {
                if (entry.getBuild() == null) continue;
                list.add(entry.getBuild());
            }
            return list;
        }
        return null;
    }

    public void setEntryFailureMessage(GerritTriggeredEvent event, AbstractBuild r, String failureMessage) {
        MemoryImprint.Entry entry;
        MemoryImprint pb = this.getMemoryImprint(event);
        if (pb != null && (entry = pb.getEntry(r.getProject())) != null) {
            logger.info("Recording unsuccessful message for {}: {}", (Object)event, (Object)failureMessage);
            entry.setUnsuccessfulMessage(failureMessage);
        }
    }

    public static class MemoryImprint {
        private GerritTriggeredEvent event;
        private List<Entry> list = new ArrayList<Entry>();

        public MemoryImprint(GerritTriggeredEvent event) {
            this.event = event;
        }

        public MemoryImprint(GerritTriggeredEvent event, AbstractProject project) {
            this.event = event;
            this.set(project);
        }

        public GerritTriggeredEvent getEvent() {
            return this.event;
        }

        public synchronized Entry[] getEntries() {
            return this.list.toArray(new Entry[this.list.size()]);
        }

        protected synchronized void set(AbstractProject project, AbstractBuild build) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                this.list.add(entry);
            } else {
                entry.setBuild(build);
            }
        }

        protected synchronized void set(AbstractProject project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            }
        }

        protected synchronized void reset(AbstractProject project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            } else {
                entry.setBuild(null);
                entry.setBuildCompleted(false);
            }
        }

        private synchronized void set(AbstractProject project, AbstractBuild build, boolean buildCompleted) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                entry.setBuildCompleted(buildCompleted);
                this.list.add(entry);
            } else {
                if (entry.getBuild() == null) {
                    entry.setBuild(build);
                }
                entry.setBuildCompleted(buildCompleted);
            }
        }

        public synchronized boolean isAllBuildsSet() {
            for (Entry entry : this.list) {
                if (entry.getBuild() != null) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean isAllBuildsCompleted() {
            for (Entry entry : this.list) {
                if (entry.isBuildCompleted()) continue;
                return false;
            }
            return true;
        }

        public synchronized String getStatusReport() {
            StringBuilder str = new StringBuilder("");
            for (Entry entry : this.list) {
                if (entry.getProject() != null) {
                    str.append("  Project/Build: [").append(entry.getProject().getName()).append("]");
                    str.append(": [#");
                    if (entry.getBuild() != null) {
                        str.append(entry.getBuild().getNumber());
                        str.append(": ").append(entry.getBuild().getResult());
                    } else {
                        str.append("XX: NULL");
                    }
                    str.append("] Completed: ").append(entry.isBuildCompleted());
                } else {
                    str.append("  Project/Build: MISSING PROJECT!");
                }
                str.append("\n");
            }
            return str.toString();
        }

        private Entry getEntry(AbstractProject project) {
            for (Entry entry : this.list) {
                if (!entry.getProject().equals(project)) continue;
                return entry;
            }
            return null;
        }

        public synchronized BuildsStartedStats getBuildsStartedStats() {
            int started = 0;
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) continue;
                ++started;
            }
            return new BuildsStartedStats(this.event, this.list.size(), started);
        }

        public synchronized boolean areAllBuildResultsSkipped() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) {
                    return false;
                }
                if (!entry.isBuildCompleted()) {
                    return false;
                }
                Result buildResult = entry.getBuild().getResult();
                GerritTrigger trigger = GerritTrigger.getTrigger(entry.getProject());
                if (Logic.shouldSkip(trigger.getSkipVote(), buildResult)) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean wereAllBuildsSuccessful() {
            if (this.areAllBuildResultsSkipped()) {
                for (Entry entry : this.list) {
                    if (entry.getBuild() == null) {
                        return false;
                    }
                    if (!entry.isBuildCompleted()) {
                        return false;
                    }
                    Result buildResult = entry.getBuild().getResult();
                    if (buildResult == Result.SUCCESS) continue;
                    return false;
                }
            } else {
                for (Entry entry : this.list) {
                    GerritTrigger trigger;
                    if (entry.getBuild() == null) {
                        return false;
                    }
                    if (!entry.isBuildCompleted()) {
                        return false;
                    }
                    Result buildResult = entry.getBuild().getResult();
                    if (buildResult == Result.SUCCESS || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), buildResult)) continue;
                    return false;
                }
            }
            return true;
        }

        public synchronized boolean wereAnyBuildsFailed() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null || !entry.isBuildCompleted() || entry.getBuild().getResult() != Result.FAILURE) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean wereAnyBuildsUnstable() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null || !entry.isBuildCompleted() || entry.getBuild().getResult() != Result.UNSTABLE) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean wereAllBuildsNotBuilt() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) {
                    return false;
                }
                if (!entry.isBuildCompleted()) {
                    return false;
                }
                Result buildResult = entry.getBuild().getResult();
                if (buildResult == Result.NOT_BUILT) continue;
                return false;
            }
            return true;
        }

        public static class Entry {
            private AbstractProject project;
            private AbstractBuild build;
            private boolean buildCompleted;
            private String unsuccessfulMessage;

            private Entry(AbstractProject project, AbstractBuild build) {
                this.project = project;
                this.build = build;
                this.buildCompleted = false;
            }

            private Entry(AbstractProject project) {
                this.project = project;
                this.buildCompleted = false;
            }

            public AbstractProject getProject() {
                return this.project;
            }

            public AbstractBuild getBuild() {
                return this.build;
            }

            private void setBuild(AbstractBuild build) {
                this.build = build;
            }

            private void setUnsuccessfulMessage(String unsuccessfulMessage) {
                this.unsuccessfulMessage = unsuccessfulMessage;
            }

            public String getUnsuccessfulMessage() {
                return this.unsuccessfulMessage;
            }

            public boolean isBuildCompleted() {
                return this.buildCompleted;
            }

            private void setBuildCompleted(boolean buildCompleted) {
                this.buildCompleted = buildCompleted;
            }
        }
    }

    private class GerritTriggeredEventComparator
    implements Comparator<GerritTriggeredEvent> {
        private GerritTriggeredEventComparator() {
        }

        @Override
        public int compare(GerritTriggeredEvent o1, GerritTriggeredEvent o2) {
            return new Integer(o1.hashCode()).compareTo(new Integer(o2.hashCode()));
        }
    }
}

