/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.NotificationFactory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(ordinal=10003.0)
public class ToGerritRunListener
extends RunListener<AbstractBuild> {
    public static final int ORDINAL = 10003;
    private static final Logger logger = LoggerFactory.getLogger(ToGerritRunListener.class);
    private static ToGerritRunListener instance;
    private transient BuildMemory memory = new BuildMemory();

    public ToGerritRunListener() {
        super(AbstractBuild.class);
    }

    public static ToGerritRunListener getInstance() {
        if (instance == null) {
            for (RunListener listener : ToGerritRunListener.all()) {
                if (!(listener instanceof ToGerritRunListener)) continue;
                instance = (ToGerritRunListener)listener;
                break;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onCompleted(AbstractBuild r, TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.info("Completed. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null) {
            this.cleanUpGerritCauses(cause, r);
            GerritTriggeredEvent event = cause.getEvent();
            if (GerritTrigger.getTrigger(r.getProject()) != null) {
                GerritTrigger.getTrigger(r.getProject()).notifyBuildEnded(event);
            }
            event.fireBuildCompleted(r);
            if (!cause.isSilentMode()) {
                this.memory.completed(event, r);
                if (r.getResult().isWorseThan(Result.SUCCESS)) {
                    try {
                        String failureMessage = this.obtainFailureMessage(event, r, listener);
                        logger.info("Obtained failure message: {}", (Object)failureMessage);
                        this.memory.setEntryFailureMessage(event, r, failureMessage);
                    }
                    catch (IOException e) {
                        listener.error("[gerrit-trigger] Unable to read failure message from the workspace.");
                        logger.warn("IOException while obtaining failure message for build: " + r.getDisplayName(), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        listener.error("[gerrit-trigger] Unable to read failure message from the workspace.");
                        logger.warn("InterruptedException while obtaining failure message for build: " + r.getDisplayName(), (Throwable)e);
                    }
                }
                this.updateTriggerContexts(r);
                if (this.memory.isAllBuildsCompleted(event)) {
                    try {
                        logger.info("All Builds are completed for cause: {}", (Object)cause);
                        event.fireAllBuildsCompleted();
                        NotificationFactory.getInstance().queueBuildCompleted(this.memory.getMemoryImprint(event), listener);
                    }
                    finally {
                        this.memory.forget(event);
                    }
                } else {
                    logger.info("Waiting for more builds to complete for cause [{}]. Status: \n{}", (Object)cause, (Object)this.memory.getStatusReport(event));
                }
            }
        }
    }

    public synchronized void onStarted(AbstractBuild r, TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.debug("Started. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null) {
            this.cleanUpGerritCauses(cause, r);
            this.setThisBuild(r);
            if (cause.getEvent() != null) {
                cause.getEvent().fireBuildStarted(r);
            }
            if (!cause.isSilentMode()) {
                this.memory.started(cause.getEvent(), r);
                this.updateTriggerContexts(r);
                BuildsStartedStats stats = this.memory.getBuildsStartedStats(cause.getEvent());
                NotificationFactory.getInstance().queueBuildStarted(r, listener, cause.getEvent(), stats);
            }
            logger.info("Gerrit build [{}] Started for cause: [{}].", (Object)r, (Object)cause);
            logger.info("MemoryStatus:\n{}", (Object)this.memory.getStatusReport(cause.getEvent()));
        }
    }

    protected void updateTriggerContexts(AbstractBuild r) {
        List causes = r.getCauses();
        for (Cause cause : causes) {
            if (!(cause instanceof GerritCause)) continue;
            this.memory.updateTriggerContext((GerritCause)cause, r);
        }
    }

    protected void setThisBuild(AbstractBuild r) {
        List causes = r.getCauses();
        for (Cause cause : causes) {
            if (!(cause instanceof GerritCause)) continue;
            ((GerritCause)cause).getContext().setThisBuild(r);
        }
    }

    protected void cleanUpGerritCauses(GerritCause firstFound, AbstractBuild build) {
        List causes = ((CauseAction)build.getAction(CauseAction.class)).getCauses();
        int pos = causes.indexOf((Object)firstFound) + 1;
        while (pos < causes.size()) {
            Cause c = (Cause)causes.get(pos);
            if (c.equals((Object)firstFound)) {
                causes.remove(pos);
                continue;
            }
            ++pos;
        }
    }

    public synchronized void onTriggered(AbstractProject project, GerritTriggeredEvent event) {
        this.memory.triggered(event, project);
        event.fireProjectTriggered(project);
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] triggered by Gerrit: [{}]", (Object)name, (Object)event);
    }

    public synchronized void onRetriggered(AbstractProject project, GerritTriggeredEvent event, List<AbstractBuild> otherBuilds) {
        this.memory.retriggered(event, project, otherBuilds);
        event.fireProjectTriggered(project);
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] re-triggered by Gerrit-User: [{}]", (Object)name, (Object)event);
    }

    public boolean isBuilding(AbstractProject project, GerritTriggeredEvent event) {
        if (project == null || event == null) {
            return false;
        }
        return this.memory.isBuilding(event, project);
    }

    public boolean isBuilding(GerritTriggeredEvent event) {
        if (event == null) {
            return false;
        }
        return this.memory.isBuilding(event);
    }

    private GerritCause getCause(AbstractBuild build) {
        return (GerritCause)build.getCause(GerritCause.class);
    }

    protected FilePath[] getMatchingWorkspaceFiles(FilePath ws, String filepath) throws IOException, InterruptedException {
        return ws.list(filepath);
    }

    protected String getExpandedContent(FilePath path, EnvVars envVars) throws IOException, InterruptedException {
        if (path.exists()) {
            return envVars.expand(path.readToString());
        }
        return null;
    }

    private String obtainFailureMessage(GerritTriggeredEvent event, AbstractBuild build, TaskListener listener) throws IOException, InterruptedException {
        AbstractProject project = build.getProject();
        String content = null;
        GerritTrigger trigger = GerritTrigger.getTrigger(project);
        if (trigger != null) {
            String filepath = trigger.getBuildUnsuccessfulFilepath();
            logger.debug("Looking for failure message in file glob: {}", (Object)filepath);
            if (filepath != null && !filepath.isEmpty()) {
                EnvVars envVars = listener == null ? build.getEnvironment() : build.getEnvironment(listener);
                filepath = envVars.expand(filepath);
                Object[] matches = this.getMatchingWorkspaceFiles(build.getWorkspace(), filepath);
                logger.debug("Found matching workspace files: {}", matches);
                if (matches.length > 0) {
                    Object path = matches[0];
                    content = this.getExpandedContent((FilePath)path, envVars);
                    logger.info("Obtained failure message from file: {}", (Object)content);
                }
            }
        }
        return content;
    }
}

