/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritMessageProvider;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.Logic;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterExpander {
    public static final int DEFAULT_PARAMETERS_COUNT = 11;
    public static final String MESSAGE_DELIMITER = " : ";
    private static final Logger logger = LoggerFactory.getLogger(ParameterExpander.class);
    private IGerritHudsonTriggerConfig config;
    private Hudson hudson;

    public ParameterExpander(IGerritHudsonTriggerConfig config, Hudson hudson) {
        this.config = config;
        this.hudson = hudson;
    }

    public ParameterExpander(IGerritHudsonTriggerConfig config) {
        this(config, Hudson.getInstance());
    }

    public String getBuildStartedCommand(AbstractBuild r, TaskListener taskListener, ChangeBasedEvent event, BuildsStartedStats stats) {
        String buildStartMessage;
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getProject());
        String gerritCmd = this.config.getGerritCmdBuildStarted();
        Map<String, String> parameters = this.createStandardParameters(r, (GerritTriggeredEvent)event, this.getBuildStartedCodeReviewValue(r), this.getBuildStartedVerifiedValue(r));
        StringBuilder startedStats = new StringBuilder();
        if (stats.getTotalBuildsToStart() > 1) {
            startedStats.append(stats.toString());
        }
        if ((buildStartMessage = trigger.getBuildStartMessage()) != null && !buildStartMessage.equals("")) {
            startedStats.append("\n\n").append(buildStartMessage);
        }
        if (this.config.isEnablePluginMessages()) {
            for (GerritMessageProvider messageProvider : ParameterExpander.emptyIfNull(GerritMessageProvider.all())) {
                String extensionMessage = messageProvider.getBuildStartedMessage(r);
                if (extensionMessage == null) continue;
                startedStats.append("\n\n").append(extensionMessage);
            }
        }
        parameters.put("STARTED_STATS", startedStats.toString());
        return this.expandParameters(gerritCmd, r, taskListener, parameters);
    }

    private static <T> Iterable<T> emptyIfNull(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return iterable;
    }

    private int getBuildStartedVerifiedValue(AbstractBuild r) {
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getProject());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedVerifiedValue();
        }
        if (trigger.getGerritBuildStartedVerifiedValue() != null) {
            Integer value = trigger.getGerritBuildStartedVerifiedValue();
            logger.trace("BuildStartedVerified overridden in project config. returning {}", (Object)value);
            return value;
        }
        int value = this.config.getGerritBuildStartedVerifiedValue();
        logger.trace("BuildStartedVerified standard value used {}", (Object)value);
        return value;
    }

    private int getBuildStartedCodeReviewValue(AbstractBuild r) {
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getProject());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedCodeReviewValue();
        }
        if (trigger.getGerritBuildStartedCodeReviewValue() != null) {
            Integer value = trigger.getGerritBuildStartedCodeReviewValue();
            logger.trace("BuildStartedCodeReview overridden in project config. returning {}", (Object)value);
            return value;
        }
        int value = this.config.getGerritBuildStartedCodeReviewValue();
        logger.trace("BuildStartedCodeReview standard value used {}", (Object)value);
        return value;
    }

    private Map<String, String> createStandardParameters(AbstractBuild r, GerritTriggeredEvent gerritEvent, int codeReview, int verified) {
        HashMap<String, String> map = new HashMap<String, String>(11);
        if (gerritEvent instanceof ChangeBasedEvent) {
            ChangeBasedEvent event = (ChangeBasedEvent)gerritEvent;
            map.put("GERRIT_NAME", event.getChange().getProject());
            map.put("CHANGE_ID", event.getChange().getId());
            map.put("BRANCH", event.getChange().getProject());
            map.put("CHANGE", event.getChange().getNumber());
            map.put("PATCHSET", event.getPatchSet().getNumber());
            map.put("PATCHSET_REVISION", event.getPatchSet().getRevision());
            map.put("REFSPEC", StringUtil.makeRefSpec(event));
        }
        if (r != null) {
            map.put("BUILDURL", this.hudson.getRootUrl() + r.getUrl());
        }
        map.put("VERIFIED", String.valueOf(verified));
        map.put("CODE_REVIEW", String.valueOf(codeReview));
        return map;
    }

    private String expandParameters(String gerritCommand, AbstractBuild r, TaskListener taskListener, Map<String, String> parameters) {
        if (r != null && taskListener != null) {
            try {
                gerritCommand = r.getEnvironment(taskListener).expand(gerritCommand);
            }
            catch (Exception ex) {
                logger.error("Failed to expand env vars into gerrit cmd. Gerrit won't be notified!!", (Throwable)ex);
                return null;
            }
        }
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            gerritCommand = gerritCommand.replace("<" + param.getKey() + ">", param.getValue());
        }
        return gerritCommand;
    }

    protected int getCodeReviewValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulCodeReviewValue() != null) {
                return trigger.getGerritBuildSuccessfulCodeReviewValue();
            }
            return this.config.getGerritBuildSuccessfulCodeReviewValue();
        }
        if (res == Result.FAILURE || res == Result.ABORTED) {
            if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
                return trigger.getGerritBuildFailedCodeReviewValue();
            }
            return this.config.getGerritBuildFailedCodeReviewValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableCodeReviewValue() != null) {
                return trigger.getGerritBuildUnstableCodeReviewValue();
            }
            return this.config.getGerritBuildUnstableCodeReviewValue();
        }
        if (res == Result.NOT_BUILT) {
            if (trigger.getGerritBuildNotBuiltCodeReviewValue() != null) {
                return trigger.getGerritBuildNotBuiltCodeReviewValue();
            }
            return this.config.getGerritBuildNotBuiltCodeReviewValue();
        }
        if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
            return trigger.getGerritBuildFailedCodeReviewValue();
        }
        return this.config.getGerritBuildFailedCodeReviewValue();
    }

    protected int getVerifiedValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulVerifiedValue() != null) {
                return trigger.getGerritBuildSuccessfulVerifiedValue();
            }
            return this.config.getGerritBuildSuccessfulVerifiedValue();
        }
        if (res == Result.FAILURE || res == Result.ABORTED) {
            if (trigger.getGerritBuildFailedVerifiedValue() != null) {
                return trigger.getGerritBuildFailedVerifiedValue();
            }
            return this.config.getGerritBuildFailedVerifiedValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableVerifiedValue() != null) {
                return trigger.getGerritBuildUnstableVerifiedValue();
            }
            return this.config.getGerritBuildUnstableVerifiedValue();
        }
        if (res == Result.NOT_BUILT) {
            if (trigger.getGerritBuildNotBuiltVerifiedValue() != null) {
                return trigger.getGerritBuildNotBuiltVerifiedValue();
            }
            return this.config.getGerritBuildNotBuiltVerifiedValue();
        }
        if (trigger.getGerritBuildFailedVerifiedValue() != null) {
            return trigger.getGerritBuildFailedVerifiedValue();
        }
        return this.config.getGerritBuildFailedVerifiedValue();
    }

    protected int getMinimumVerifiedValue(BuildMemory.MemoryImprint memoryImprint, boolean onlyBuilt) {
        int verified = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            GerritTrigger trigger;
            Result result = entry.getBuild().getResult();
            if (onlyBuilt && result == Result.NOT_BUILT || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), result)) continue;
            verified = Math.min(verified, this.getVerifiedValue(result, trigger));
        }
        if (verified >= Integer.MAX_VALUE) {
            verified = 0;
        }
        return verified;
    }

    protected int getMinimumCodeReviewValue(BuildMemory.MemoryImprint memoryImprint, boolean onlyBuilt) {
        int codeReview = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            GerritTrigger trigger;
            Result result = entry.getBuild().getResult();
            if (onlyBuilt && result == Result.NOT_BUILT || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), result)) continue;
            codeReview = Math.min(codeReview, this.getCodeReviewValue(result, trigger));
        }
        if (codeReview >= Integer.MAX_VALUE) {
            codeReview = 0;
        }
        return codeReview;
    }

    public String getBuildCompletedCommand(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        String command;
        boolean onlyCountBuilt = true;
        if (memoryImprint.wereAllBuildsSuccessful()) {
            command = this.config.getGerritCmdBuildSuccessful();
        } else if (memoryImprint.wereAnyBuildsFailed()) {
            command = this.config.getGerritCmdBuildFailed();
        } else if (memoryImprint.wereAnyBuildsUnstable()) {
            command = this.config.getGerritCmdBuildUnstable();
        } else if (memoryImprint.wereAllBuildsNotBuilt()) {
            onlyCountBuilt = false;
            command = this.config.getGerritCmdBuildNotBuilt();
        } else {
            command = this.config.getGerritCmdBuildFailed();
        }
        int verified = 0;
        int codeReview = 0;
        if (memoryImprint.getEvent().isScorable()) {
            verified = this.getMinimumVerifiedValue(memoryImprint, onlyCountBuilt);
            codeReview = this.getMinimumCodeReviewValue(memoryImprint, onlyCountBuilt);
        }
        Map<String, String> parameters = this.createStandardParameters(null, memoryImprint.getEvent(), codeReview, verified);
        parameters.put("BUILDS_STATS", this.createBuildsStats(memoryImprint, listener, parameters));
        AbstractBuild build = null;
        BuildMemory.MemoryImprint.Entry[] entries = memoryImprint.getEntries();
        if (entries.length > 0 && entries[0].getBuild() != null) {
            build = entries[0].getBuild();
        }
        return this.expandParameters(command, build, listener, parameters);
    }

    private String createBuildsStats(BuildMemory.MemoryImprint memoryImprint, TaskListener listener, Map<String, String> parameters) {
        StringBuilder str = new StringBuilder("");
        String rootUrl = this.hudson.getRootUrl();
        String unsuccessfulMessage = null;
        BuildMemory.MemoryImprint.Entry[] entries = memoryImprint.getEntries();
        if (entries.length > 0) {
            for (BuildMemory.MemoryImprint.Entry entry : entries) {
                AbstractBuild build = entry.getBuild();
                if (build == null) continue;
                GerritTrigger trigger = GerritTrigger.getTrigger(build.getProject());
                Result res = build.getResult();
                String customMessage = null;
                str.append("\n\n");
                if (trigger.getCustomUrl() == null || trigger.getCustomUrl().isEmpty()) {
                    str.append(rootUrl).append(entry.getBuild().getUrl());
                } else {
                    str.append(this.expandParameters(trigger.getCustomUrl(), build, listener, parameters));
                }
                str.append(MESSAGE_DELIMITER);
                customMessage = res == Result.SUCCESS ? trigger.getBuildSuccessfulMessage() : (res == Result.FAILURE || res == Result.ABORTED ? trigger.getBuildFailureMessage() : (res == Result.UNSTABLE ? trigger.getBuildUnstableMessage() : (res == Result.NOT_BUILT ? trigger.getBuildNotBuiltMessage() : trigger.getBuildFailureMessage())));
                if (customMessage == null || customMessage.equals("")) {
                    str.append(res.toString());
                    if (Logic.shouldSkip(trigger.getSkipVote(), res)) {
                        str.append(" (skipped)");
                    }
                } else {
                    str.append(customMessage);
                }
                if (res.isWorseThan(Result.SUCCESS) && null != (unsuccessfulMessage = entry.getUnsuccessfulMessage()) && !unsuccessfulMessage.isEmpty()) {
                    logger.trace("Using unsuccessful message from file.");
                    str.append(" <<<\n");
                    str.append(unsuccessfulMessage.trim());
                    str.append("\n>>>");
                }
                if (!this.config.isEnablePluginMessages()) continue;
                for (GerritMessageProvider messageProvider : ParameterExpander.emptyIfNull(GerritMessageProvider.all())) {
                    String extensionMessage = messageProvider.getBuildCompletedMessage(build);
                    if (extensionMessage == null) continue;
                    str.append("\n\n").append(extensionMessage);
                }
            }
        } else {
            logger.error("I got a request to create build statistics, but no entries where found!");
        }
        return str.toString();
    }
}

