/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritCmdRunner;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.cmd.AbstractSendCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritNotifier;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.BuildCompletedCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.BuildStartedCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;

public class NotificationFactory {
    private static NotificationFactory instance;

    public static NotificationFactory getInstance() {
        if (instance == null) {
            instance = new NotificationFactory();
        }
        return instance;
    }

    public IGerritHudsonTriggerConfig getConfig() {
        if (PluginImpl.getInstance() == null) {
            throw new IllegalStateException("PluginImpl has not been loaded yet!");
        }
        return PluginImpl.getInstance().getConfig();
    }

    public GerritNotifier createGerritNotifier(GerritCmdRunner cmdRunner) {
        IGerritHudsonTriggerConfig config = this.getConfig();
        return this.createGerritNotifier(config, cmdRunner);
    }

    public GerritNotifier createGerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner) {
        return new GerritNotifier(config, cmdRunner);
    }

    public void queueBuildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        BuildCompletedCommandJob job = new BuildCompletedCommandJob(this.getConfig(), memoryImprint, listener);
        GerritSendCommandQueue.queue((AbstractSendCommandJob)job);
    }

    public void queueBuildStarted(AbstractBuild build, TaskListener listener, GerritTriggeredEvent event, BuildsStartedStats stats) {
        BuildStartedCommandJob job = new BuildStartedCommandJob(this.getConfig(), build, listener, event, stats);
        GerritSendCommandQueue.queue((AbstractSendCommandJob)job);
    }
}

