/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritDefaultValues;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class Config
implements IGerritHudsonTriggerConfig {
    public static final int DEFAULT_GERRIT_BUILD_STARTED_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_STARTED_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_CODE_REVIEW_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_VERIFIED_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_VERIFIED_VALUE = 1;
    public static final int DEFAULT_GERRIT_BUILD_NOT_BUILT_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_NOT_BUILT_CODE_REVIEW_VALUE = 0;
    public static final boolean DEFAULT_ENABLE_MANUAL_TRIGGER = true;
    public static final boolean DEFAULT_ENABLE_PLUGIN_MESSAGES = true;
    public static final boolean DEFAULT_BUILD_CURRENT_PATCHES_ONLY = false;
    private String gerritHostName;
    private int gerritSshPort;
    private String gerritUserName;
    private String gerritEMail;
    private File gerritAuthKeyFile;
    private String gerritAuthKeyFilePassword;
    private boolean gerritBuildCurrentPatchesOnly;
    private int numberOfWorkerThreads;
    private String gerritVerifiedCmdBuildSuccessful;
    private String gerritVerifiedCmdBuildUnstable;
    private String gerritVerifiedCmdBuildFailed;
    private String gerritVerifiedCmdBuildStarted;
    private String gerritVerifiedCmdBuildNotBuilt;
    private String gerritFrontEndUrl;
    private int gerritBuildStartedVerifiedValue;
    private int gerritBuildStartedCodeReviewValue;
    private int gerritBuildSuccessfulVerifiedValue;
    private int gerritBuildSuccessfulCodeReviewValue;
    private int gerritBuildFailedVerifiedValue;
    private int gerritBuildFailedCodeReviewValue;
    private int gerritBuildUnstableVerifiedValue;
    private int gerritBuildUnstableCodeReviewValue;
    private int gerritBuildNotBuiltVerifiedValue;
    private int gerritBuildNotBuiltCodeReviewValue;
    private boolean enableManualTrigger;
    private boolean enablePluginMessages;
    private int numberOfSendingWorkerThreads;
    private int buildScheduleDelay;
    private int dynamicConfigRefreshInterval;
    private List<VerdictCategory> categories;

    public Config(JSONObject formData) {
        this.setValues(formData);
    }

    @Override
    public void setValues(JSONObject formData) {
        this.gerritHostName = formData.optString("gerritHostName", "");
        this.gerritSshPort = formData.optInt("gerritSshPort", 29418);
        this.gerritUserName = formData.optString("gerritUserName", "");
        this.gerritEMail = formData.optString("gerritEMail", "");
        String file = formData.optString("gerritAuthKeyFile", null);
        this.gerritAuthKeyFile = file != null ? new File(file) : GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE;
        this.gerritAuthKeyFilePassword = formData.optString("gerritAuthKeyFilePassword", GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE_PASSWORD);
        if (this.gerritAuthKeyFilePassword != null && this.gerritAuthKeyFilePassword.length() <= 0) {
            this.gerritAuthKeyFilePassword = null;
        }
        this.gerritBuildCurrentPatchesOnly = formData.optBoolean("gerritBuildCurrentPatchesOnly", false);
        this.numberOfWorkerThreads = formData.optInt("numberOfReceivingWorkerThreads", 3);
        if (this.numberOfWorkerThreads <= 0) {
            this.numberOfWorkerThreads = 3;
        }
        this.numberOfSendingWorkerThreads = formData.optInt("numberOfSendingWorkerThreads", 1);
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        this.gerritBuildStartedVerifiedValue = formData.optInt("gerritBuildStartedVerifiedValue", 0);
        this.gerritBuildStartedCodeReviewValue = formData.optInt("gerritBuildStartedCodeReviewValue", 0);
        this.gerritBuildSuccessfulVerifiedValue = formData.optInt("gerritBuildSuccessfulVerifiedValue", 1);
        this.gerritBuildSuccessfulCodeReviewValue = formData.optInt("gerritBuildSuccessfulCodeReviewValue", 0);
        this.gerritBuildFailedVerifiedValue = formData.optInt("gerritBuildFailedVerifiedValue", -1);
        this.gerritBuildFailedCodeReviewValue = formData.optInt("gerritBuildFailedCodeReviewValue", 0);
        this.gerritBuildUnstableVerifiedValue = formData.optInt("gerritBuildUnstableVerifiedValue", 0);
        this.gerritBuildUnstableCodeReviewValue = formData.optInt("gerritBuildUnstableCodeReviewValue", -1);
        this.gerritBuildNotBuiltVerifiedValue = formData.optInt("gerritBuildNotBuiltVerifiedValue", 0);
        this.gerritBuildNotBuiltCodeReviewValue = formData.optInt("gerritBuildNotBuiltCodeReviewValue", 0);
        this.gerritVerifiedCmdBuildStarted = formData.optString("gerritVerifiedCmdBuildStarted", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Started <BUILDURL> <STARTED_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildFailed = formData.optString("gerritVerifiedCmdBuildFailed", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Failed <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildSuccessful = formData.optString("gerritVerifiedCmdBuildSuccessful", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Successful <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildUnstable = formData.optString("gerritVerifiedCmdBuildUnstable", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Unstable <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildNotBuilt = formData.optString("gerritVerifiedCmdBuildNotBuilt", "gerrit approve <CHANGE>,<PATCHSET> --message 'No Builds Executed <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritFrontEndUrl = formData.optString("gerritFrontEndUrl", "");
        this.enableManualTrigger = formData.optBoolean("enableManualTrigger", true);
        this.enablePluginMessages = formData.optBoolean("enablePluginMessages", true);
        this.buildScheduleDelay = formData.optInt("buildScheduleDelay", 3);
        if (this.buildScheduleDelay <= 3) {
            this.buildScheduleDelay = 3;
        }
        this.dynamicConfigRefreshInterval = formData.optInt("dynamicConfigRefreshInterval", 30);
        this.categories = new LinkedList<VerdictCategory>();
        if (formData.has("verdictCategories")) {
            Object cat = formData.get("verdictCategories");
            if (cat instanceof JSONArray) {
                for (Object jsonObject : (JSONArray)cat) {
                    this.categories.add(VerdictCategory.createVerdictCategoryFromJSON((JSONObject)jsonObject));
                }
            } else if (cat instanceof JSONObject) {
                this.categories.add(VerdictCategory.createVerdictCategoryFromJSON((JSONObject)cat));
            }
        }
    }

    public Config() {
        this(new JSONObject(false));
    }

    public Config(JSONObject formData, StaplerRequest req) {
        this(formData);
    }

    public File getGerritAuthKeyFile() {
        return this.gerritAuthKeyFile;
    }

    public void setGerritAuthKeyFile(File gerritAuthKeyFile) {
        this.gerritAuthKeyFile = gerritAuthKeyFile;
    }

    public String getGerritAuthKeyFilePassword() {
        return this.gerritAuthKeyFilePassword;
    }

    public void setGerritAuthKeyFilePassword(String gerritAuthKeyFilePassword) {
        this.gerritAuthKeyFilePassword = gerritAuthKeyFilePassword;
    }

    public void setGerritBuildCurrentPatchesOnly(boolean gerritBuildCurrentPatchesOnly) {
        this.gerritBuildCurrentPatchesOnly = gerritBuildCurrentPatchesOnly;
    }

    @Override
    public String getGerritFrontEndUrl() {
        String url = this.gerritFrontEndUrl;
        if (url != null && !url.equals("") && !url.endsWith("/")) {
            url = url + '/';
        }
        return url;
    }

    public void setGerritFrontEndURL(String gerritFrontEndURL) {
        this.gerritFrontEndUrl = gerritFrontEndURL;
    }

    public String getGerritHostName() {
        return this.gerritHostName;
    }

    public void setGerritHostName(String gerritHostName) {
        this.gerritHostName = gerritHostName;
    }

    public int getGerritSshPort() {
        return this.gerritSshPort;
    }

    public void setGerritSshPort(int gerritSshPort) {
        this.gerritSshPort = gerritSshPort;
    }

    @Override
    public int getBuildScheduleDelay() {
        return this.buildScheduleDelay;
    }

    public void setBuildScheduleDelay(int buildScheduleDelay) {
        this.buildScheduleDelay = buildScheduleDelay;
    }

    @Override
    public int getDynamicConfigRefreshInterval() {
        if (this.dynamicConfigRefreshInterval == 0) {
            this.dynamicConfigRefreshInterval = 30;
        } else if (this.dynamicConfigRefreshInterval < 5) {
            this.dynamicConfigRefreshInterval = 5;
        }
        return this.dynamicConfigRefreshInterval;
    }

    public void setDynamicConfigRefreshInterval(int dynamicConfigRefreshInterval) {
        this.dynamicConfigRefreshInterval = dynamicConfigRefreshInterval;
    }

    public String getGerritUserName() {
        return this.gerritUserName;
    }

    public void setGerritUserName(String gerritUserName) {
        this.gerritUserName = gerritUserName;
    }

    public String getGerritEMail() {
        return this.gerritEMail;
    }

    public void setGerritEMail(String gerritEMail) {
        this.gerritEMail = gerritEMail;
    }

    public int getNumberOfReceivingWorkerThreads() {
        if (this.numberOfWorkerThreads <= 0) {
            this.numberOfWorkerThreads = 3;
        }
        return this.numberOfWorkerThreads;
    }

    public int getNumberOfSendingWorkerThreads() {
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        return this.numberOfSendingWorkerThreads;
    }

    public void setNumberOfReceivingWorkerThreads(int numberOfReceivingWorkerThreads) {
        this.numberOfWorkerThreads = numberOfReceivingWorkerThreads;
    }

    @Override
    public boolean isGerritBuildCurrentPatchesOnly() {
        return this.gerritBuildCurrentPatchesOnly;
    }

    @Override
    public String getGerritCmdBuildSuccessful() {
        return this.gerritVerifiedCmdBuildSuccessful;
    }

    public void setGerritVerifiedCmdBuildSuccessful(String cmd) {
        this.gerritVerifiedCmdBuildSuccessful = cmd;
    }

    @Override
    public String getGerritCmdBuildUnstable() {
        return this.gerritVerifiedCmdBuildUnstable;
    }

    public void setGerritVerifiedCmdBuildUnstable(String cmd) {
        this.gerritVerifiedCmdBuildUnstable = cmd;
    }

    @Override
    public String getGerritCmdBuildFailed() {
        return this.gerritVerifiedCmdBuildFailed;
    }

    public void setGerritVerifiedCmdBuildFailed(String cmd) {
        this.gerritVerifiedCmdBuildFailed = cmd;
    }

    @Override
    public String getGerritCmdBuildStarted() {
        return this.gerritVerifiedCmdBuildStarted;
    }

    public void setGerritVerifiedCmdBuildStarted(String cmd) {
        this.gerritVerifiedCmdBuildStarted = cmd;
    }

    @Override
    public String getGerritCmdBuildNotBuilt() {
        return this.gerritVerifiedCmdBuildNotBuilt;
    }

    public void setGerritVerifiedCmdBuildNotBuilt(String cmd) {
        this.gerritVerifiedCmdBuildNotBuilt = cmd;
    }

    @Override
    public int getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    @Override
    public int getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    @Override
    public int getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    @Override
    public int getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    @Override
    public int getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    @Override
    public int getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    @Override
    public int getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    @Override
    public int getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    @Override
    public int getGerritBuildNotBuiltVerifiedValue() {
        return this.gerritBuildNotBuiltVerifiedValue;
    }

    @Override
    public int getGerritBuildNotBuiltCodeReviewValue() {
        return this.gerritBuildNotBuiltCodeReviewValue;
    }

    @Override
    public String getGerritFrontEndUrlFor(String changeSetNumber, String revision) {
        StringBuilder str = new StringBuilder(this.getGerritFrontEndUrl());
        str.append(changeSetNumber);
        return str.toString();
    }

    @Override
    public List<VerdictCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(List<VerdictCategory> categories) {
        this.categories = categories;
    }

    @Override
    public boolean isEnableManualTrigger() {
        return this.enableManualTrigger;
    }

    public void setEnableManualTrigger(boolean enableManualTrigger) {
        this.enableManualTrigger = enableManualTrigger;
    }

    public Authentication getGerritAuthentication() {
        return new Authentication(this.gerritAuthKeyFile, this.gerritUserName, this.gerritAuthKeyFilePassword);
    }

    @Override
    public boolean hasDefaultValues() {
        return !(this.gerritHostName != null && !"".equals(this.gerritHostName) || this.gerritFrontEndUrl != null && !"".equals(this.gerritFrontEndUrl));
    }

    @Override
    public boolean isEnablePluginMessages() {
        return this.enablePluginMessages;
    }
}

