/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritHandler;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritProjectListUpdater;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContextConverter;
import com.thoughtworks.xstream.converters.Converter;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginImpl
extends Plugin {
    public static final String DISPLAY_NAME = "Gerrit Trigger";
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._GerritPermissionGroup());
    public static final Permission MANUAL_TRIGGER = new Permission(PERMISSION_GROUP, "ManualTrigger", Messages._ManualTriggerPermissionDescription(), Hudson.ADMINISTER);
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    private transient GerritHandler gerritEventManager;
    private transient GerritProjectListUpdater projectListUpdater;
    private static PluginImpl instance;
    private IGerritHudsonTriggerConfig config;
    private transient Collection<GerritEventListener> savedEventListeners;
    private transient Collection<ConnectionListener> savedConnectionListeners;

    public PluginImpl() {
        instance = this;
    }

    public IGerritHudsonTriggerConfig getConfig() {
        return this.config;
    }

    public static PluginImpl getInstance() {
        return instance;
    }

    public void start() throws Exception {
        logger.info("Starting");
        PluginImpl.doXStreamRegistrations();
        this.loadConfig();
        this.projectListUpdater = new GerritProjectListUpdater();
        this.projectListUpdater.start();
        GerritSendCommandQueue.getInstance((GerritConnectionConfig)this.config);
        List<VerdictCategory> categories = this.config.getCategories();
        if (categories == null) {
            categories = new LinkedList<VerdictCategory>();
        }
        if (categories.isEmpty()) {
            categories.add(new VerdictCategory("CRVW", "Code Review"));
            categories.add(new VerdictCategory("VRIF", "Verified"));
        }
        if (!this.config.hasDefaultValues()) {
            this.startManager();
            logger.info("Started");
        }
    }

    protected static void doXStreamRegistrations() {
        logger.trace("doing XStream alias registrations.");
        Items.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Hudson.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Run.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        logger.trace("XStream alias registrations done.");
    }

    private void loadConfig() throws IOException {
        logger.trace("loadConfig");
        this.load();
        if (this.config == null) {
            this.config = new Config();
        }
    }

    public void stop() throws Exception {
        logger.info("Shutting down...");
        this.projectListUpdater.shutdown();
        this.projectListUpdater.join();
        if (this.gerritEventManager != null) {
            this.gerritEventManager.shutdown(false);
            this.gerritEventManager = null;
        }
        GerritSendCommandQueue.shutdown();
    }

    private void startManager() {
        logger.debug("starting Gerrit manager");
        this.createManager();
        this.gerritEventManager.start();
    }

    private void createManager() {
        this.gerritEventManager = new GerritHandler((GerritConnectionConfig)this.config);
        if (this.savedConnectionListeners != null) {
            this.gerritEventManager.addConnectionListeners(this.savedConnectionListeners);
            this.savedConnectionListeners = null;
        }
        if (this.savedEventListeners != null) {
            this.gerritEventManager.addEventListeners(this.savedEventListeners);
            this.savedEventListeners = null;
        }
    }

    public void addListener(GerritEventListener listener) {
        if (this.gerritEventManager != null) {
            this.gerritEventManager.addListener(listener);
        } else {
            if (this.savedEventListeners == null) {
                this.savedEventListeners = Collections.synchronizedSet(new HashSet());
            }
            this.savedEventListeners.add(listener);
        }
    }

    public void removeListener(GerritEventListener listener) {
        if (this.gerritEventManager != null) {
            this.gerritEventManager.removeListener(listener);
        } else if (this.savedEventListeners != null) {
            this.savedEventListeners.remove(listener);
        }
    }

    public void removeListener(ConnectionListener listener) {
        if (this.gerritEventManager != null) {
            this.gerritEventManager.removeListener(listener);
        } else if (this.savedConnectionListeners != null) {
            this.savedConnectionListeners.remove(listener);
        }
    }

    public synchronized void startConnection() throws Exception {
        if (this.gerritEventManager == null) {
            this.createManager();
            if (this.savedEventListeners != null) {
                this.gerritEventManager.addEventListeners(this.savedEventListeners);
                this.savedEventListeners = null;
            }
            if (this.savedConnectionListeners != null) {
                this.gerritEventManager.addConnectionListeners(this.savedConnectionListeners);
                this.savedConnectionListeners = null;
            }
            this.gerritEventManager.start();
        } else {
            logger.warn("Already started!");
        }
    }

    public synchronized void stopConnection() throws Exception {
        if (this.gerritEventManager != null) {
            this.savedEventListeners = null;
            this.savedConnectionListeners = null;
            this.gerritEventManager.shutdown(true);
            this.savedEventListeners = this.gerritEventManager.removeAllEventListeners();
            this.savedConnectionListeners = this.gerritEventManager.removeAllConnectionListeners();
            this.gerritEventManager = null;
        } else {
            logger.warn("Was told to shutdown again!?");
        }
    }

    public void restartConnection() throws Exception {
        this.stopConnection();
        this.startConnection();
    }

    public boolean addListener(ConnectionListener listener) {
        boolean connected = false;
        if (this.gerritEventManager != null) {
            connected = this.gerritEventManager.addListener(listener);
        } else {
            if (this.savedConnectionListeners == null) {
                this.savedConnectionListeners = Collections.synchronizedSet(new HashSet());
            }
            this.savedConnectionListeners.add(listener);
        }
        return connected;
    }

    public List<String> getGerritProjects() {
        if (this.projectListUpdater != null) {
            return this.projectListUpdater.getGerritProjects();
        }
        return new ArrayList<String>();
    }

    public void triggerEvent(GerritEvent event) {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Manager not started!");
        }
        this.gerritEventManager.triggerEvent(event);
    }

    public String getGerritVersion() {
        if (this.gerritEventManager != null) {
            return this.gerritEventManager.getGerritVersion();
        }
        return null;
    }
}

